/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.january.MetadataException;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.metadata.AxesMetadata;
import org.eclipse.january.metadata.DimensionMetadata;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.IMetadata;
import org.eclipse.january.metadata.MaskMetadata;
import org.eclipse.january.metadata.Metadata;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.OriginMetadata;
import org.eclipse.january.metadata.PeemMetadata;
import org.eclipse.january.metadata.internal.AxesMetadataImpl;
import org.eclipse.january.metadata.internal.DimensionMetadataImpl;
import org.eclipse.january.metadata.internal.ErrorMetadataImpl;
import org.eclipse.january.metadata.internal.MaskMetadataImpl;
import org.eclipse.january.metadata.internal.OriginMetadataImpl;
import org.eclipse.january.metadata.internal.PeemMetadataImpl;

public class MetadataFactory {
    static Map<Class<? extends MetadataType>, Class<? extends MetadataType>> metadataClasses = MetadataFactory.createMap();

    private MetadataFactory() {
    }

    private static Map<Class<? extends MetadataType>, Class<? extends MetadataType>> createMap() {
        HashMap<Class<? extends MetadataType>, Class<? extends MetadataType>> map = new HashMap<Class<? extends MetadataType>, Class<? extends MetadataType>>();
        map.put(IMetadata.class, Metadata.class);
        map.put(ErrorMetadata.class, ErrorMetadataImpl.class);
        map.put(AxesMetadata.class, AxesMetadataImpl.class);
        map.put(DimensionMetadata.class, DimensionMetadataImpl.class);
        map.put(MaskMetadata.class, MaskMetadataImpl.class);
        map.put(OriginMetadata.class, OriginMetadataImpl.class);
        map.put(PeemMetadata.class, PeemMetadataImpl.class);
        return map;
    }

    public static <T extends MetadataType> T createMetadata(Class<T> clazz, Object ... arguments) throws MetadataException {
        Class<? extends MetadataType> mdClass = metadataClasses.get(clazz);
        if (mdClass == null) {
            return null;
        }
        MetadataType obj = null;
        try {
            obj = mdClass.newInstance();
        }
        catch (Exception e) {
            throw new MetadataException("Could not create metadata object", e);
        }
        try {
            Method[] methodArray = mdClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals("initialize")) {
                    m.invoke((Object)obj, arguments);
                    return (T)obj;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new MetadataException("Could not initialize object", e);
        }
        throw new MetadataException("Could not find initialize method");
    }

    public static <T extends MetadataType> void registerClass(Class<T> clazz) {
        Class<? extends MetadataType> iClass = LazyDatasetBase.findMetadataTypeSubInterfaces(clazz);
        metadataClasses.put(iClass, clazz);
    }
}

