/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.apache.commons.math3.complex.Complex;

public interface BinaryOperation {
    public boolean booleanOperate(long var1, long var3);

    public long longOperate(long var1, long var3);

    public double doubleOperate(double var1, double var3);

    public void complexOperate(double[] var1, double var2, double var4, double var6, double var8);

    public String toString();

    public static class Addition
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L || b != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a + b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a + b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            out[0] = ra + rb;
            out[1] = ia + ib;
        }

        @Override
        public String toString() {
            return "+";
        }
    }

    public static class Division
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L && b == 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return b == 0L ? 0L : a / b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a / b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            if (ib == 0.0) {
                out[0] = ra / rb;
                out[1] = ia / rb;
            } else if (rb == 0.0) {
                out[0] = ia / ib;
                out[1] = -ra / ib;
            } else if (Math.abs(rb) < Math.abs(ib)) {
                double q = rb / ib;
                double den = rb * q + ib;
                out[0] = (ra * q + ia) / den;
                out[1] = (ia * q - rb) / den;
            } else {
                double q = ib / rb;
                double den = ib * q + rb;
                out[0] = (ia * q + ra) / den;
                out[1] = (ia - ra * q) / den;
            }
        }

        @Override
        public String toString() {
            return "/";
        }
    }

    public static class DivisionTowardsFloor
    extends Division {
        @Override
        public long longOperate(long a, long b) {
            if (b == 0L) {
                return 0L;
            }
            long ox = a / b;
            if (a != ox * b && a < 0L ^ b < 0L) {
                --ox;
            }
            return ox;
        }
    }

    public static class DivisionWithZero
    extends Division {
        @Override
        public double doubleOperate(double a, double b) {
            return b == 0.0 ? 0.0 : a / b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            if (ib == 0.0) {
                if (rb == 0.0) {
                    out[0] = 0.0;
                    out[1] = 0.0;
                } else {
                    out[0] = ra / rb;
                    out[1] = ia / rb;
                }
            } else if (rb == 0.0) {
                out[0] = ia / ib;
                out[1] = -ra / ib;
            } else if (Math.abs(rb) < Math.abs(ib)) {
                double q = rb / ib;
                double den = rb * q + ib;
                out[0] = (ra * q + ia) / den;
                out[1] = (ia * q - rb) / den;
            } else {
                double q = ib / rb;
                double den = ib * q + rb;
                out[0] = (ia * q + ra) / den;
                out[1] = (ia - ra * q) / den;
            }
        }
    }

    public static class Exponentiation
    extends Stub {
        @Override
        public double doubleOperate(double a, double b) {
            return Math.pow(a, b);
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            Complex c = new Complex(ra, ia);
            c = ib == 0.0 ? c.pow(rb) : c.pow(new Complex(rb, ib));
            out[0] = c.getReal();
            out[1] = c.getImaginary();
        }

        @Override
        public String toString() {
            return "**";
        }
    }

    public static class Multiplication
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L && b != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a * b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a * b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            out[0] = ra * rb - ia * ib;
            out[1] = ra * ib + ia * rb;
        }

        @Override
        public String toString() {
            return "*";
        }
    }

    public static class Remainder
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            throw new IllegalArgumentException("remainder does not support booleans");
        }

        @Override
        public long longOperate(long a, long b) {
            return b == 0L ? 0L : a % b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a % b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("remainder does not support complex numbers");
        }

        @Override
        public String toString() {
            return "%";
        }
    }

    public static class Stub
    implements BinaryOperation {
        @Override
        public double doubleOperate(double a, double b) {
            return 0.0;
        }

        @Override
        public boolean booleanOperate(long a, long b) {
            return this.doubleOperate(a, b) != 0.0;
        }

        private static long toLong(double d) {
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return 0L;
            }
            return (long)d;
        }

        @Override
        public long longOperate(long a, long b) {
            return Stub.toLong(this.doubleOperate(a, b));
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
        }
    }

    public static class Subtraction
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L || b == 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a - b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a - b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            out[0] = ra - rb;
            out[1] = ia - ib;
        }

        @Override
        public String toString() {
            return "-";
        }
    }
}

