/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.DataComponent;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.MasterDetailsPair;

@XmlRootElement(name="MasterDetailsComponent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MasterDetailsComponent
extends ICEObject
implements Component {
    @XmlElement(name="MasterDetailsPairs")
    private ArrayList<MasterDetailsPair> masterDetailsPairs;
    @XmlElement(name="AllowedMasters")
    private ArrayList<String> allowedMasters;
    @XmlElement(name="MasterDetailsTemplateList")
    private ArrayList<MasterDetailsPair> masterDetailsTemplateList;
    @XmlAttribute
    private Integer counter;
    @XmlElement(name="GlobalsComponent")
    private DataComponent globals;
    @XmlAttribute
    private boolean toggleAddRemoveButton;

    public MasterDetailsComponent() {
        this.listeners = new ArrayList();
        this.allowedMasters = new ArrayList();
        this.masterDetailsPairs = new ArrayList();
        this.masterDetailsTemplateList = new ArrayList();
        this.toggleAddRemoveButton = true;
        this.counter = 1;
    }

    public void setTemplates(ArrayList<String> masterTypeList, ArrayList<DataComponent> detailList) {
        if (masterTypeList == null || detailList == null) {
            return;
        }
        if (masterTypeList.isEmpty() || detailList.isEmpty() || masterTypeList.size() != detailList.size() || !this.masterDetailsTemplateList.isEmpty()) {
            return;
        }
        this.masterDetailsPairs = new ArrayList();
        this.allowedMasters = new ArrayList();
        this.masterDetailsTemplateList = new ArrayList();
        int i = 0;
        while (i < detailList.size()) {
            MasterDetailsPair mDetailsP = new MasterDetailsPair();
            mDetailsP.setMasterDetailsPairId(i);
            mDetailsP.setDetails((DataComponent)detailList.get(i).clone());
            mDetailsP.setMaster(masterTypeList.get(i));
            this.masterDetailsTemplateList.add(mDetailsP);
            this.allowedMasters.add(mDetailsP.getMaster());
            ++i;
        }
        this.notifyListeners();
    }

    public void setTemplates(ArrayList<MasterDetailsPair> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return;
        }
        if (!this.masterDetailsTemplateList.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < pairs.size()) {
            MasterDetailsPair mDetailsP = (MasterDetailsPair)pairs.get(i).clone();
            this.masterDetailsTemplateList.add(mDetailsP);
            this.allowedMasters.add(mDetailsP.getMaster());
            ++i;
        }
        this.notifyListeners();
    }

    public DataComponent getDetails(int masterId) {
        if (this.masterDetailsTemplateList.isEmpty() || masterId < 0 || masterId >= this.counter) {
            return null;
        }
        int i = 0;
        while (i < this.masterDetailsPairs.size()) {
            if (this.masterDetailsPairs.get(i).getMasterDetailsPairId() == masterId) {
                return this.masterDetailsPairs.get(i).getDetails();
            }
            ++i;
        }
        return null;
    }

    public int addMaster() {
        MasterDetailsPair mDetailsP = null;
        if (this.masterDetailsTemplateList.isEmpty()) {
            return -1;
        }
        if (this.masterDetailsTemplateList.isEmpty()) {
            return -1;
        }
        mDetailsP = (MasterDetailsPair)this.masterDetailsTemplateList.get(0).clone();
        mDetailsP.setMasterDetailsPairId(this.counter);
        this.masterDetailsPairs.add(mDetailsP);
        this.counter = this.counter + 1;
        this.notifyListeners();
        return this.counter - 1;
    }

    public boolean deleteMaster(int id) {
        if (this.masterDetailsTemplateList == null) {
            return false;
        }
        if (id < 0 || id > this.counter) {
            return false;
        }
        int i = 0;
        while (i < this.masterDetailsPairs.size()) {
            if (this.masterDetailsPairs.get(i).getMasterDetailsPairId() == id) {
                this.masterDetailsPairs.remove(i);
                this.notifyListeners();
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getMasterValue(int id) {
        if (this.masterDetailsTemplateList.isEmpty()) {
            return null;
        }
        if (id < 0 || id > this.counter) {
            return null;
        }
        int i = 0;
        while (i < this.masterDetailsPairs.size()) {
            if (this.masterDetailsPairs.get(i).getMasterDetailsPairId() == id) {
                return this.masterDetailsPairs.get(i).getMaster();
            }
            ++i;
        }
        return null;
    }

    public boolean setMasterInstanceValue(int id, String value) {
        DataComponent dataComponent = null;
        if (value == null || id < 0 || id > this.counter) {
            return false;
        }
        if (this.masterDetailsTemplateList.isEmpty()) {
            return false;
        }
        if (!this.allowedMasters.contains(value)) {
            return false;
        }
        int i = 0;
        while (i < this.masterDetailsPairs.size()) {
            if (this.masterDetailsPairs.get(i).getMasterDetailsPairId() == id) {
                int j = 0;
                while (j < this.masterDetailsTemplateList.size()) {
                    if (this.masterDetailsTemplateList.get(j).getMaster().equals(value)) {
                        dataComponent = (DataComponent)this.masterDetailsTemplateList.get(j).getDetails().clone();
                    }
                    ++j;
                }
                if (dataComponent == null) {
                    return false;
                }
                if (this.masterDetailsPairs.get(i).getMaster().equals(value)) {
                    this.notifyListeners();
                    return true;
                }
                this.masterDetailsPairs.get(i).setMaster(value);
                this.masterDetailsPairs.get(i).setDetails(dataComponent);
                this.notifyListeners();
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList<String> getAllowedMasterValues() {
        ArrayList<String> tempString = new ArrayList<String>();
        if (this.allowedMasters.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.allowedMasters.size()) {
            tempString.add(this.allowedMasters.get(i));
            ++i;
        }
        return tempString;
    }

    @Override
    public boolean equals(Object otherMasterDetailsComponent) {
        boolean retVal = true;
        if (this == otherMasterDetailsComponent) {
            return true;
        }
        if (otherMasterDetailsComponent == null || !(otherMasterDetailsComponent instanceof MasterDetailsComponent)) {
            return false;
        }
        if (!super.equals(otherMasterDetailsComponent)) {
            return false;
        }
        MasterDetailsComponent castedmDetailsP = (MasterDetailsComponent)otherMasterDetailsComponent;
        if (this.globals == null || castedmDetailsP.globals == null ? this.globals != castedmDetailsP.globals : !this.globals.equals(castedmDetailsP.globals)) {
            return false;
        }
        retVal = this.allowedMasters.equals(castedmDetailsP.allowedMasters) && this.masterDetailsPairs.equals(castedmDetailsP.masterDetailsPairs) && this.masterDetailsTemplateList.equals(castedmDetailsP.masterDetailsTemplateList);
        return retVal;
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + (this.allowedMasters == null ? 0 : this.allowedMasters.hashCode());
        hash = 31 * hash + (this.counter == null ? 0 : this.counter.hashCode());
        hash = 31 * hash + (this.masterDetailsPairs == null ? 0 : this.masterDetailsPairs.hashCode());
        hash = 31 * hash + (this.masterDetailsTemplateList == null ? 0 : this.masterDetailsTemplateList.hashCode());
        hash = 31 * hash + (this.globals == null ? 0 : this.globals.hashCode());
        return hash;
    }

    public void copy(MasterDetailsComponent otherMasterDetailsComponent) {
        if (otherMasterDetailsComponent == null) {
            return;
        }
        super.copy(otherMasterDetailsComponent);
        this.counter = otherMasterDetailsComponent.counter;
        this.allowedMasters.clear();
        int i = 0;
        while (i < otherMasterDetailsComponent.allowedMasters.size()) {
            this.allowedMasters.add(otherMasterDetailsComponent.allowedMasters.get(i));
            ++i;
        }
        this.masterDetailsPairs.clear();
        i = 0;
        while (i < otherMasterDetailsComponent.masterDetailsPairs.size()) {
            this.masterDetailsPairs.add((MasterDetailsPair)otherMasterDetailsComponent.masterDetailsPairs.get(i).clone());
            ++i;
        }
        this.masterDetailsTemplateList.clear();
        i = 0;
        while (i < otherMasterDetailsComponent.masterDetailsTemplateList.size()) {
            this.masterDetailsTemplateList.add((MasterDetailsPair)otherMasterDetailsComponent.masterDetailsTemplateList.get(i).clone());
            ++i;
        }
        this.globals = otherMasterDetailsComponent.globals == null ? null : (DataComponent)otherMasterDetailsComponent.globals.clone();
        this.toggleAddRemoveButton = otherMasterDetailsComponent.toggleAddRemoveButton;
        this.notifyListeners();
    }

    @Override
    public Object clone() {
        MasterDetailsComponent mDetailsP = new MasterDetailsComponent();
        mDetailsP.copy(this);
        return mDetailsP;
    }

    private void rectifyDetailsBlock(int id) {
    }

    public int numberOfMasters() {
        return this.masterDetailsPairs.size();
    }

    public DataComponent getGlobalsComponent() {
        return this.globals;
    }

    public void setGlobalsComponent(DataComponent globals) {
        this.globals = globals;
        this.notifyListeners();
    }

    public String getMasterAtIndex(int index) {
        if (index < 0 || index > this.masterDetailsPairs.size() || this.masterDetailsPairs.isEmpty()) {
            return null;
        }
        return this.masterDetailsPairs.get(index).getMaster();
    }

    public DataComponent getDetailsAtIndex(int index) {
        if (index < 0 || index > this.masterDetailsPairs.size() || this.masterDetailsPairs.isEmpty()) {
            return null;
        }
        return this.masterDetailsPairs.get(index).getDetails();
    }

    public String getUniqueMasterValue(int id) {
        if (id < 0 || id > this.counter || this.masterDetailsPairs.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.masterDetailsPairs.size()) {
            if (id == this.masterDetailsPairs.get(i).getMasterDetailsPairId()) {
                return String.valueOf(id) + " " + this.masterDetailsPairs.get(i).getMaster();
            }
            ++i;
        }
        return null;
    }

    public String getUniqueMasterValueAtIndex(int index) {
        if (index < 0 || index > this.masterDetailsPairs.size() || this.masterDetailsPairs.isEmpty()) {
            return null;
        }
        return this.masterDetailsPairs.get(index).getMasterDetailsPairId() + " " + this.masterDetailsPairs.get(index).getMaster();
    }

    public boolean deleteMasterAtIndex(int index) {
        if (index < 0 || index > this.masterDetailsPairs.size() || this.masterDetailsPairs.isEmpty()) {
            return false;
        }
        this.masterDetailsPairs.remove(index);
        return true;
    }

    public boolean canAddRemoveButton() {
        return this.toggleAddRemoveButton;
    }

    public void toggleAddRemoveButton(boolean toggle) {
        this.toggleAddRemoveButton = toggle;
    }

    @Override
    public void update(String updatedKey, String newValue) {
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        visitor.visit(this);
    }
}

