/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.webapplicationexceptiontest;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 8214271241869777148L;
    private static final Response.Status STATUS = Response.Status.INTERNAL_SERVER_ERROR;
    protected static final String MESSAGE = "TCK WebApplicationException description";
    protected static final String HOST = "www.jcp.org";

    public JAXRSClientIT() {
        this.setContextRoot("/jaxrs_api_rs_webapplicationexceptiontest_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void statusNullTest() throws JAXRSCommonClient.Fault {
        Response.Status st = null;
        try {
            WebApplicationException e = new WebApplicationException(st);
            throw new JAXRSCommonClient.Fault("No exception thrown.  Test FAILED", e);
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected exception caught.  Test PASSED");
        }
        catch (Throwable th) {
            throw new JAXRSCommonClient.Fault("Wrong exception caught.  Test FAILED", th.getCause());
        }
    }

    @Test
    public void throwableStatusTest1() throws JAXRSCommonClient.Fault {
        Response.Status st = null;
        try {
            WebApplicationException e = new WebApplicationException(new Throwable("CTS-WebApplicationExceptionTest-throwableStatusTest1-FAIL"), st);
            throw new JAXRSCommonClient.Fault("No exception thrown.  Test FAILED", e);
        }
        catch (IllegalArgumentException ilex) {
            TestUtil.logTrace("Expected exception thrown.  Test PASS");
        }
        catch (Throwable th) {
            throw new JAXRSCommonClient.Fault("Wrong-Exception", th.getCause());
        }
    }

    @Test
    public void constructorStringTest() throws JAXRSCommonClient.Fault {
        WebApplicationException e = new WebApplicationException(MESSAGE);
        JAXRSClientIT.assertResponse(e, STATUS);
        JAXRSClientIT.assertMessage(e);
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            Response response = this.buildResponse(status);
            WebApplicationException e = new WebApplicationException(MESSAGE, response);
            this.assertResponse(e, status, HOST);
            JAXRSClientIT.assertMessage(e);
        }
    }

    @Test
    public void constructorStringNullResponseTest() throws JAXRSCommonClient.Fault {
        WebApplicationException e = new WebApplicationException(MESSAGE, (Response)null);
        JAXRSClientIT.assertResponse(e, STATUS);
        JAXRSClientIT.assertMessage(e);
    }

    @Test
    public void constructorStringIntTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            WebApplicationException e = new WebApplicationException(MESSAGE, status.getStatusCode());
            JAXRSClientIT.assertResponse(e, status);
            JAXRSClientIT.assertMessage(e);
        }
    }

    @Test
    public void constructorStringStatusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            WebApplicationException e = new WebApplicationException(MESSAGE, status);
            JAXRSClientIT.assertResponse(e, status);
            JAXRSClientIT.assertMessage(e);
        }
    }

    @Test
    public void constructorStringNullStatusThrowsIAETest() throws JAXRSCommonClient.Fault {
        try {
            WebApplicationException e = new WebApplicationException(MESSAGE, (Response.Status)null);
            JAXRSClientIT.fault(new Object[]{"No IllegalArgumentException has been thrown, built expcetion is", e});
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected when", "null Status");
        }
    }

    @Test
    public void constructorStringThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            WebApplicationException e = new WebApplicationException(MESSAGE, t);
            JAXRSClientIT.assertResponse(e, STATUS);
            JAXRSClientIT.assertMessage(e);
            JAXRSClientIT.assertCause(e, t);
        }
    }

    @Test
    public void constructorStringThrowableResponseTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            Response response = this.buildResponse(status);
            for (Throwable t : throwables) {
                WebApplicationException e = new WebApplicationException(MESSAGE, t, response);
                this.assertResponse(e, status, HOST);
                JAXRSClientIT.assertMessage(e);
                JAXRSClientIT.assertCause(e, t);
            }
        }
    }

    @Test
    public void constructorStringThrowableNullResponseTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            WebApplicationException e = new WebApplicationException(MESSAGE, t, (Response)null);
            JAXRSClientIT.assertResponse(e, STATUS);
            JAXRSClientIT.assertMessage(e);
            JAXRSClientIT.assertCause(e, t);
        }
    }

    @Test
    public void constructorStringThrowableIntTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            for (Throwable t : throwables) {
                WebApplicationException e = new WebApplicationException(MESSAGE, t, status.getStatusCode());
                JAXRSClientIT.assertResponse(e, status);
                JAXRSClientIT.assertMessage(e);
                JAXRSClientIT.assertCause(e, t);
            }
        }
    }

    @Test
    public void constructorStringThrowableStatusTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            for (Throwable t : throwables) {
                WebApplicationException e = new WebApplicationException(MESSAGE, t, status);
                JAXRSClientIT.assertResponse(e, status);
                JAXRSClientIT.assertMessage(e);
                JAXRSClientIT.assertCause(e, t);
            }
        }
    }

    @Test
    public void constructorStringThrowableNullStatusThrowsIAETest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            try {
                WebApplicationException e = new WebApplicationException(MESSAGE, t, (Response.Status)null);
                JAXRSClientIT.fault(new Object[]{"IllegalArgumentException has not been thrown, exception:", e});
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown when", "null Status as expected");
            }
        }
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).header("Host", (Object)HOST).build();
    }

    protected static void assertResponse(WebApplicationException e, Response.Status status) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), status.getStatusCode(), "response contains unexpected status", response.getStatus(), "response:", response);
        JAXRSClientIT.logMsg("response contains expected", status, "status");
    }

    protected void assertResponse(WebApplicationException e, Response.Status status, String host) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertResponse(e, status);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected static void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected static void assertMessage(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

