/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.SocketConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public class InterruptableSocketConnection
extends SocketConnection {
    public InterruptableSocketConnection(Socket socket) throws IOException {
        super(socket);
    }

    public InterruptableSocketConnection(String host, int port) throws IOException {
        super(host, port);
    }

    @Override
    public InputStream getInputStream() {
        return new InterruptableInputStream();
    }

    class InterruptableInputStream
    extends InputStream {
        private boolean reading = false;
        private Object data;

        InterruptableInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b);
            if (n == -1) {
                return -1;
            }
            n = 0xFF & b[0];
            return n;
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            if (count == 0) {
                return 0;
            }
            try {
                return new InterruptableReader().read(buffer, offset, count);
            }
            catch (InterruptedException ie) {
                InterruptedIOException iio = new InterruptedIOException("Interrupted while waiting for agent response");
                iio.fillInStackTrace();
                throw iio;
            }
        }

        @Override
        public void close() throws IOException {
            InterruptableSocketConnection.this.socketInput.close();
        }

        private synchronized void waitWhileReading() throws InterruptedException {
            while (this.reading) {
                this.wait();
            }
        }

        class InterruptableReader {
            private IOException ioe;
            private int n;

            InterruptableReader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] buffer, int offset, int count) throws IOException, InterruptedException {
                InterruptableInputStream interruptableInputStream = InterruptableInputStream.this;
                synchronized (interruptableInputStream) {
                    this.ioe = null;
                    this.n = -1;
                    this.readInThread(buffer, offset, count);
                    InterruptableInputStream.this.waitWhileReading();
                    if (this.ioe != null) {
                        throw this.ioe;
                    }
                    return this.n;
                }
            }

            private void readInThread(byte[] buffer, int offset, int count) {
                final byte[] b = buffer;
                final int o = offset;
                final int c = count;
                Thread reader = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            InterruptableReader.this.n = InterruptableSocketConnection.this.socketInput.read(b, o, c);
                        }
                        catch (IOException io) {
                            InterruptableReader.this.ioe = io;
                        }
                        finally {
                            InterruptableInputStream interruptableInputStream = InterruptableInputStream.this;
                            synchronized (interruptableInputStream) {
                                InterruptableInputStream.this.reading = false;
                                InterruptableInputStream.this.notifyAll();
                            }
                        }
                    }
                };
                InterruptableInputStream.this.reading = true;
                reader.start();
            }
        }
    }
}

