/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.annotations.signaturetest;

import ee.jakarta.tck.annotations.signaturetest.SigTestData;
import ee.jakarta.tck.annotations.signaturetest.SigTestResult;
import ee.jakarta.tck.annotations.signaturetest.SignatureTestDriver;
import ee.jakarta.tck.annotations.signaturetest.SignatureTestDriverFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;

public abstract class SigTest {
    private static final System.Logger logger = System.getLogger(SigTest.class.getName());
    protected SignatureTestDriver driver;
    protected SigTestData testInfo;

    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        return null;
    }

    protected abstract String[] getPackages();

    protected String[] getClasses() {
        return new String[0];
    }

    public void setup() {
        try {
            logger.log(System.Logger.Level.TRACE, "$$$ SigTest.setup() called");
            this.testInfo = new SigTestData();
            logger.log(System.Logger.Level.TRACE, "$$$ SigTest.setup() complete");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception " + e.getMessage());
        }
    }

    public void signatureTest(String mapFile, String packageFile, Properties mapFileAsProps, String[] packages) throws Exception {
        SigTestResult results = null;
        String repositoryDir = System.getProperty("java.io.tmpdir");
        String[] classes = this.getClasses();
        String testClasspath = this.testInfo.getTestClasspath();
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        String jimageDir = this.testInfo.getJImageDir();
        File f = new File(jimageDir);
        f.mkdirs();
        String javaHome = System.getProperty("java.home");
        logger.log(System.Logger.Level.INFO, "Executing JImage");
        try {
            ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
            logger.log(System.Logger.Level.INFO, javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = out.readLine()) != null) {
                logger.log(System.Logger.Level.INFO, line);
            }
            int rc = proc.waitFor();
            logger.log(System.Logger.Level.INFO, "JImage RC = " + rc);
            out.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Exception while executing JImage!  Some tests may fail.");
            e.printStackTrace();
        }
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            logger.log(System.Logger.Level.INFO, results.toString());
            if (!results.passed()) {
                logger.log(System.Logger.Level.TRACE, "results.passed() returned false");
                throw new Exception();
            }
            logger.log(System.Logger.Level.TRACE, "$$$ SigTest.test1() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new Exception("SigTest.test1() failed!, diffs found");
            }
            logger.log(System.Logger.Level.ERROR, "Unexpected exception " + e.getMessage());
            throw new Exception("test failed with an unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToTempFile(InputStream inputStream, String tempFilePrefix, String tempFileSuffix) throws IOException {
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File file = File.createTempFile(tempFilePrefix, tempFileSuffix);
            file.deleteOnExit();
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file2 = file;
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToSigFile(InputStream inputStream, String apiPackage, String packageVersion) throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File sigfile = new File(tmpdir + File.separator + apiPackage + ".sig_" + packageVersion);
            if (sigfile.exists()) {
                sigfile.delete();
                logger.log(System.Logger.Level.INFO, "Existing signature file deleted to create new one");
            }
            if (!sigfile.createNewFile()) {
                logger.log(System.Logger.Level.ERROR, "signature file is not created");
            }
            outputStream = new FileOutputStream(sigfile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file = sigfile;
            return file;
        }
    }

    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "$$$ SigTest.cleanup() called");
        try {
            this.getSigTestDriver().cleanupImpl();
            logger.log(System.Logger.Level.TRACE, "$$$ SigTest.cleanup() returning");
        }
        catch (Exception e) {
            throw new Exception("Cleanup failed!", e);
        }
    }
}

