/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.gen.files;

import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.docs.intent.markup.markup.Image;
import org.eclipse.swt.graphics.ImageData;

public class ImageUtility {
    public String getImageWidth(Image imageDSL) {
        double ratio = this.getWidthRatio(imageDSL);
        return Double.valueOf(ratio).toString();
    }

    public Double getWidthRatio(Image imageDSL) {
        double textWidthResolution = 900.0;
        ImageData data = this.getImageData(imageDSL);
        if (data != null) {
            double ratio = (double)data.width / textWidthResolution;
            return ratio;
        }
        return 1.0;
    }

    public Boolean hasLandscapeRatio(Image imageDSL) {
        if (this.getWidthRatio(imageDSL) > 1.0) {
            return true;
        }
        return false;
    }

    public Boolean hasLongLandscapeRatio(Image imageDSL) {
        double widthRatio = this.getWidthRatio(imageDSL);
        if (widthRatio > 1.3) {
            return true;
        }
        return false;
    }

    public Boolean isSmall(Image imageDSL) {
        ImageData data = this.getImageData(imageDSL);
        if (data != null) {
            if (data.width <= 600) {
                return true;
            }
            return false;
        }
        return true;
    }

    private ImageData getImageData(Image imageDSL) {
        try {
            String absoluteImagePath;
            URI imageURI = URI.createURI((String)imageDSL.getUrl());
            if (imageURI.hasAbsolutePath()) {
                absoluteImagePath = imageURI.toString();
            } else {
                URI modelPath = imageDSL.eResource().getURI().trimSegments(1);
                absoluteImagePath = String.valueOf(modelPath.toFileString()) + "/" + imageDSL.getUrl();
            }
            ImageData data = new ImageData(absoluteImagePath);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

