/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class CompositeActionGroup
extends ActionGroup {
    private List<ActionGroup> groups;

    public CompositeActionGroup(ActionGroup ... groups) {
        ActionGroup[] actionGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ActionGroup group = actionGroupArray[n2];
            if (group == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        this.groups = new ArrayList<ActionGroup>(Arrays.asList(groups));
    }

    public CompositeActionGroup() {
        this.groups = new ArrayList<ActionGroup>();
    }

    public final void add(ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException();
        }
        this.groups.add(group);
    }

    public final void add(ActionGroup ... groups) {
        ActionGroup[] actionGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ActionGroup group = actionGroupArray[n2];
            this.add(group);
            ++n2;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        for (ActionGroup group : this.groups) {
            group.setContext(context);
        }
    }

    public void dispose() {
        for (ActionGroup group : this.groups) {
            group.dispose();
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        for (ActionGroup group : this.groups) {
            group.fillContextMenu(menu);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        for (ActionGroup group : this.groups) {
            group.fillActionBars(actionBars);
        }
    }

    public void updateActionBars() {
        for (ActionGroup group : this.groups) {
            group.updateActionBars();
        }
    }
}

