/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import junit.framework.TestCase;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.IElementDeltaImpl;
import org.eclipse.handly.model.impl.support.ElementDelta;
import org.eclipse.handly.model.impl.support.SimpleElement;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;

public class ElementDeltaTest
extends TestCase {
    private SimpleElement root;
    private ElementDelta delta;
    private ElementDelta.Builder builder;

    protected void setUp() throws Exception {
        super.setUp();
        this.root = new SimpleElement(null, "root", new SimpleModelManager());
        this.delta = new ElementDelta((IElement)this.root);
        this.builder = new ElementDelta.Builder(this.delta);
    }

    public void test00() {
        this.assertDelta("root[?]: {}");
    }

    public void test01() {
        this.builder.added((IElement)this.root);
        this.assertDelta("root[+]: {}");
    }

    public void test02() {
        this.builder.removed((IElement)this.root);
        this.assertDelta("root[-]: {}");
    }

    public void test03() {
        this.builder.changed((IElement)this.root, 1L);
        this.assertDelta("root[*]: {CONTENT}");
    }

    public void test04() {
        this.builder.added((IElement)this.root);
        this.builder.added((IElement)this.root);
        this.assertDelta("root[+]: {}");
    }

    public void test05() {
        this.builder.added((IElement)this.root);
        this.builder.changed((IElement)this.root, 1L);
        this.assertDelta("root[+]: {}");
    }

    public void test06() {
        this.builder.added((IElement)this.root);
        this.builder.removed((IElement)this.root);
        this.assertDelta("root[?]: {}");
    }

    public void test07() {
        this.builder.removed((IElement)this.root);
        this.builder.added((IElement)this.root);
        this.assertDelta("root[*]: {CONTENT}");
    }

    public void test08() {
        this.builder.removed((IElement)this.root);
        this.builder.changed((IElement)this.root, 1L);
        this.assertDelta("root[-]: {}");
    }

    public void test09() {
        this.builder.removed((IElement)this.root);
        this.builder.removed((IElement)this.root);
        this.assertDelta("root[-]: {}");
    }

    public void test10() {
        this.builder.changed((IElement)this.root, 1L);
        this.builder.added((IElement)this.root);
        this.assertDelta("root[+]: {}");
    }

    public void test11() {
        this.builder.changed((IElement)this.root, 1L);
        this.builder.removed((IElement)this.root);
        this.assertDelta("root[-]: {}");
    }

    public void test12() {
        this.builder.changed((IElement)this.root, 1L);
        this.builder.changed((IElement)this.root, 128L);
        this.assertDelta("root[*]: {CONTENT | DESCRIPTION}");
    }

    public void test13() {
        this.delta.mergeWith_(new ElementDelta((IElement)this.root));
        this.assertDelta("root[?]: {}");
    }

    public void test14() {
        this.builder.added((IElement)this.root);
        this.delta.mergeWith_(new ElementDelta((IElement)this.root));
        this.assertDelta("root[+]: {}");
    }

    public void test15() {
        this.builder.removed((IElement)this.root);
        this.delta.mergeWith_(new ElementDelta((IElement)this.root));
        this.assertDelta("root[-]: {}");
    }

    public void test16() {
        this.builder.changed((IElement)this.root, 1L);
        this.delta.mergeWith_(new ElementDelta((IElement)this.root));
        this.assertDelta("root[*]: {CONTENT}");
    }

    public void test17() {
        this.delta.copyFrom_(new ElementDelta((IElement)this.root), false);
        this.assertDelta("root[?]: {}");
    }

    public void test18() {
        this.builder.added((IElement)this.root);
        this.delta.copyFrom_(new ElementDelta((IElement)this.root), false);
        this.assertDelta("root[+]: {}");
    }

    public void test19() {
        this.builder.removed((IElement)this.root);
        this.delta.copyFrom_(new ElementDelta((IElement)this.root), false);
        this.assertDelta("root[-]: {}");
    }

    public void test20() {
        this.builder.changed((IElement)this.root, 1L);
        this.delta.copyFrom_(new ElementDelta((IElement)this.root), false);
        this.assertDelta("root[*]: {CONTENT}");
    }

    public void test21() {
        ElementDelta d = new ElementDelta((IElement)this.root);
        d.copyFrom_(this.delta, false);
        ElementDeltaTest.assertEquals((String)"root[?]: {}", (String)d.toString());
    }

    public void test22() {
        this.builder.added((IElement)this.root);
        ElementDelta d = new ElementDelta((IElement)this.root);
        d.copyFrom_(this.delta, false);
        ElementDeltaTest.assertEquals((String)"root[+]: {}", (String)d.toString());
    }

    public void test23() {
        this.builder.removed((IElement)this.root);
        ElementDelta d = new ElementDelta((IElement)this.root);
        d.copyFrom_(this.delta, false);
        ElementDeltaTest.assertEquals((String)"root[-]: {}", (String)d.toString());
    }

    public void test24() {
        this.builder.changed((IElement)this.root, 1L);
        ElementDelta d = new ElementDelta((IElement)this.root);
        d.copyFrom_(this.delta, false);
        ElementDeltaTest.assertEquals((String)"root[*]: {CONTENT}", (String)d.toString());
    }

    public void test25() {
        this.builder.added((IElement)this.root);
        ElementDelta d = new ElementDelta((IElement)this.root);
        d.setKind_(2);
        try {
            d.copyFrom_(this.delta, false);
            ElementDeltaTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test26() {
        this.builder.added((IElement)this.root.getChild("A"));
        this.builder.removed((IElement)this.root.getChild("B"));
        this.builder.changed((IElement)this.root.getChild("C"), 1L);
        this.assertDelta("root[*]: {CHILDREN}\n  A[+]: {}\n  B[-]: {}\n  C[*]: {CONTENT}");
        ElementDeltaTest.assertEquals((int)3, (int)this.delta.getAffectedChildren_().length);
        ElementDeltaTest.assertEquals((int)1, (int)this.delta.getAddedChildren_().length);
        ElementDeltaTest.assertEquals((int)1, (int)this.delta.getRemovedChildren_().length);
        ElementDeltaTest.assertEquals((int)1, (int)this.delta.getChangedChildren_().length);
    }

    public void test27() {
        this.builder.added((IElement)this.root);
        this.builder.added((IElement)this.root.getChild("A"));
        this.builder.removed((IElement)this.root.getChild("B"));
        this.builder.changed((IElement)this.root.getChild("C"), 1L);
        this.assertDelta("root[+]: {}");
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getAffectedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getAddedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getRemovedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getChangedChildren_().length);
    }

    public void test28() {
        this.builder.removed((IElement)this.root);
        this.builder.added((IElement)this.root.getChild("A"));
        this.builder.removed((IElement)this.root.getChild("B"));
        this.builder.changed((IElement)this.root.getChild("C"), 1L);
        this.assertDelta("root[-]: {}");
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getAffectedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getAddedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getRemovedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getChangedChildren_().length);
    }

    public void test29() {
        SimpleElement a = this.root.getChild("A");
        SimpleElement b = this.root.getChild("B");
        this.builder.movedFrom((IElement)a, (IElement)b);
        this.builder.movedTo((IElement)b, (IElement)a);
        this.assertDelta("root[*]: {CHILDREN}\n  A[-]: {MOVED_TO(B)}\n  B[+]: {MOVED_FROM(A)}");
        ElementDeltaTest.assertEquals((int)2, (int)this.delta.getAffectedChildren_().length);
        ElementDeltaTest.assertEquals((int)1, (int)this.delta.getAddedChildren_().length);
        ElementDeltaTest.assertEquals((int)1, (int)this.delta.getRemovedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getChangedChildren_().length);
    }

    public void test30() {
        SimpleElement a = this.root.getChild("A");
        SimpleElement b = a.getChild("B");
        SimpleElement c = b.getChild("C");
        this.builder.added((IElement)b);
        this.builder.removed((IElement)c);
        this.assertDelta("root[*]: {CHILDREN}\n  A[*]: {CHILDREN}\n    B[+]: {}");
        ElementDeltaTest.assertEquals((Object)this.delta, (Object)this.delta.findDelta_((IElement)this.root));
        ElementDeltaTest.assertEquals((int)1, (int)this.delta.getAffectedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getAddedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)this.delta.getRemovedChildren_().length);
        ElementDeltaTest.assertEquals((int)1, (int)this.delta.getChangedChildren_().length);
        ElementDelta d = this.delta.findDelta_((IElement)a);
        ElementDeltaTest.assertEquals((int)1, (int)d.getAffectedChildren_().length);
        ElementDeltaTest.assertEquals((int)1, (int)d.getAddedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)d.getRemovedChildren_().length);
        ElementDeltaTest.assertEquals((int)0, (int)d.getChangedChildren_().length);
        ElementDeltaTest.assertEquals((Object)d.getAddedChildren_()[0], (Object)this.delta.findDelta_((IElement)b));
        ElementDeltaTest.assertNull((Object)this.delta.findDelta_((IElement)c));
    }

    public void test31() {
        SimpleModelManager manager = new SimpleModelManager();
        SimpleSourceFile sourceFile = new SimpleSourceFile((IElement)this.root, "a.foo", null, manager);
        ElementDelta.Builder builder = new ElementDelta.Builder(new ElementDelta((IElement)sourceFile));
        builder.added((IElement)new SimpleElement((IElement)sourceFile, "A", manager));
        ElementDeltaTest.assertEquals((String)"a.foo[*]: {CHILDREN | FINE GRAINED}\n  A[+]: {}", (String)builder.getDelta().toString());
    }

    public void test32() {
        IResourceDelta[] resourceDeltas;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        int i = 1;
        while (i < 10) {
            factory.create((IResource)workspaceRoot.getProject("p" + i));
            ++i;
        }
        IResourceDelta[] iResourceDeltaArray = resourceDeltas = factory.getDelta().getAffectedChildren();
        int n = resourceDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            this.builder.addResourceDelta((IElement)this.root, resourceDelta);
            ++n2;
        }
        this.assertDelta("root[*]: {CONTENT}\n  ResourceDelta(/p1)[+]\n  ResourceDelta(/p2)[+]\n  ResourceDelta(/p3)[+]\n  ResourceDelta(/p4)[+]\n  ResourceDelta(/p5)[+]\n  ResourceDelta(/p6)[+]\n  ResourceDelta(/p7)[+]\n  ResourceDelta(/p8)[+]\n  ResourceDelta(/p9)[+]");
    }

    public void test33() throws Exception {
        class ResourceChangeListener
        implements IResourceChangeListener {
            volatile IResourceDelta delta;

            ResourceChangeListener() {
            }

            public void resourceChanged(IResourceChangeEvent event) {
                this.delta = event.getDelta();
            }
        }
        ResourceChangeListener listener = new ResourceChangeListener();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)listener);
        try {
            IMarker marker = workspace.getRoot().createMarker("org.eclipse.core.resources.problemmarker");
            try {
                IResourceDelta resourceDelta;
                while ((resourceDelta = listener.delta) == null || resourceDelta.getMarkerDeltas().length <= 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                IMarkerDelta[] markerDeltas = resourceDelta.getMarkerDeltas();
                this.builder.markersChanged((IElement)this.root, markerDeltas);
                this.assertDelta("root[*]: {MARKERS}");
                ElementDeltaTest.assertSame((Object)markerDeltas, (Object)this.delta.getMarkerDeltas_());
                try {
                    this.builder.markersChanged((IElement)this.root, markerDeltas);
                    ElementDeltaTest.fail();
                }
                catch (Throwable throwable) {}
            }
            finally {
                marker.delete();
            }
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    public void testBug456060() {
        this.builder.added((IElement)this.root.getChild("A"));
        this.builder.added((IElement)this.root.getChild("B"));
        this.builder.added((IElement)this.root.getChild("C"));
        this.builder.added((IElement)this.root.getChild("D"));
        this.builder.movedFrom((IElement)this.root.getChild("C"), (IElement)this.root.getChild("X"));
        this.builder.movedFrom((IElement)this.root.getChild("D"), (IElement)this.root.getChild("Y"));
    }

    public void testMalformedDeltaTree() {
        SimpleElement parent = new SimpleElement(null, "parent", new SimpleModelManager());
        SimpleElement child = parent.getChild("child");
        ElementDelta.Builder builder = new ElementDelta.Builder(new ElementDelta((IElement)child));
        try {
            builder.added((IElement)parent);
            ElementDeltaTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDefaultFindDelta() {
        SimpleElement a = this.root.getChild("A");
        SimpleElement b = a.getChild("B");
        SimpleElement c = this.root.getChild("C");
        class TestDelta
        implements IElementDeltaImpl {
            final IElement element;
            final IElementDelta[] children;

            TestDelta(IElement element, IElementDelta[] children) {
                this.element = element;
                this.children = children;
            }

            public IElement getElement_() {
                return this.element;
            }

            public IElementDelta[] getAffectedChildren_() {
                return this.children;
            }

            public int getKind_() {
                throw new UnsupportedOperationException();
            }

            public long getFlags_() {
                throw new UnsupportedOperationException();
            }

            public IElementDelta[] getAddedChildren_() {
                throw new UnsupportedOperationException();
            }

            public IElementDelta[] getRemovedChildren_() {
                throw new UnsupportedOperationException();
            }

            public IElementDelta[] getChangedChildren_() {
                throw new UnsupportedOperationException();
            }

            public IElement getMovedFromElement_() {
                throw new UnsupportedOperationException();
            }

            public IElement getMovedToElement_() {
                throw new UnsupportedOperationException();
            }

            public IMarkerDelta[] getMarkerDeltas_() {
                throw new UnsupportedOperationException();
            }

            public IResourceDelta[] getResourceDeltas_() {
                throw new UnsupportedOperationException();
            }

            public String toString_(IContext context) {
                throw new UnsupportedOperationException();
            }
        }
        TestDelta bDelta = new TestDelta((IElement)b, ElementDeltas.EMPTY_ARRAY);
        TestDelta aDelta = new TestDelta((IElement)a, new IElementDelta[]{bDelta});
        TestDelta delta = new TestDelta((IElement)this.root, new IElementDelta[]{aDelta});
        ElementDeltaTest.assertSame((Object)bDelta, (Object)delta.findDelta_((IElement)b));
        ElementDeltaTest.assertNull((Object)delta.findDelta_((IElement)c));
        ElementDeltaTest.assertNull((Object)delta.findDelta_(null));
        ElementDeltaTest.assertNull((Object)aDelta.findDelta_((IElement)c));
    }

    private void assertDelta(String expected) {
        ElementDeltaTest.assertEquals((String)expected, (String)this.delta.toString());
    }
}

