/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.SortFilterCompartmentItemsRequest;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.SortFilterContentRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;

public class SortFilterAction
extends DiagramAction {
    public SortFilterAction(IWorkbenchPage workbenchpage) {
        super(workbenchpage);
    }

    protected Request createTargetRequest() {
        return new SortFilterCompartmentItemsRequest();
    }

    public void init() {
        super.init();
        this.setId("sortfilterAction");
        this.setText(DiagramUIActionsMessages.SortFilterCompartmentsAction_ActionLabelText);
        this.setToolTipText(DiagramUIActionsMessages.SortFilterCompartmentsAction_ActionToolTipText);
        this.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SORT_FILTER);
        this.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SORT_FILTER_DISABLED);
    }

    protected boolean calculateEnabled() {
        for (Object obj : this.getSelectedObjects()) {
            IGraphicalEditPart selectedEP;
            Object model;
            if (!(obj instanceof IGraphicalEditPart) || !((model = (selectedEP = (IGraphicalEditPart)obj).getModel()) instanceof View) || ViewUtil.resolveSemanticElement((View)((View)model)) == null) continue;
            ArrayList childContributions = new ArrayList();
            List children = selectedEP.getChildren();
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) instanceof ListCompartmentEditPart) {
                    SortFilterContentRequest contentRequest = new SortFilterContentRequest(childContributions);
                    ListCompartmentEditPart editPart = (ListCompartmentEditPart)children.get(i);
                    editPart.getCommand((Request)contentRequest);
                    if (childContributions.size() > 0) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        Iterator selectedEPs = selection.iterator();
        ArrayList<EditPart> targetedEPs = new ArrayList<EditPart>();
        while (selectedEPs.hasNext()) {
            EditPart selectedEP = (EditPart)selectedEPs.next();
            targetedEPs.addAll(this.getTargetEditParts(selectedEP));
            if (targetedEPs.size() <= 0) continue;
            EditPart ep = (EditPart)targetedEPs.get(0);
            targetedEPs.clear();
            targetedEPs.add(ep);
            return targetedEPs;
        }
        return targetedEPs.isEmpty() ? Collections.EMPTY_LIST : targetedEPs;
    }

    public boolean isSelectionListener() {
        return true;
    }

    protected void updateTargetRequest() {
        ((SortFilterCompartmentItemsRequest)this.getTargetRequest()).setEditParts(this.getSelectedObjects());
    }
}

