/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.websocket;

import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.eclipse.glsp.server.gson.ServerGsonConfigurator;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.websocket.WebSocketEndpoint;

public class GLSPServerEndpoint
extends WebSocketEndpoint<GLSPClient> {
    public static final int MAX_TEXT_MESSAGE_BUFFER_SIZE = 0x800000;
    @Inject
    protected ServerGsonConfigurator gsonConfigurator;
    @Inject
    protected GLSPServer glspServer;

    protected void configure(Launcher.Builder<GLSPClient> builder) {
        builder.setLocalService((Object)this.glspServer).setRemoteInterface(GLSPClient.class).wrapMessages(this.messageWrapper()).configureGson(arg_0 -> ((ServerGsonConfigurator)this.gsonConfigurator).configureGsonBuilder(arg_0));
    }

    protected Consumer<GsonBuilder> configureGson() {
        return builder -> {
            GsonBuilder gsonBuilder = this.gsonConfigurator.configureGsonBuilder(builder);
        };
    }

    protected Function<MessageConsumer, MessageConsumer> messageWrapper() {
        return Function.identity();
    }

    protected void connect(Collection<Object> localServices, GLSPClient remoteProxy) {
        this.glspServer.connect(remoteProxy);
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.configureSession(session);
        super.onOpen(session, config);
    }

    protected void configureSession(Session session) {
        session.setMaxTextMessageBufferSize(0x800000);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.glspServer.shutdown();
    }
}

