/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.navigation;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import org.apache.log4j.Logger;

public class JsonOpenerOptions {
    private static final Logger LOGGER = Logger.getLogger(JsonOpenerOptions.class);
    private TextSelection selection;

    public JsonOpenerOptions() {
    }

    public JsonOpenerOptions(TextSelection selection) {
        this.selection = selection;
    }

    public JsonOpenerOptions(int startLine, int startCharacter, int endLine, int endCharacter) {
        this(new TextSelection(new LinePosition(startLine, startCharacter), new LinePosition(endLine, endCharacter)));
    }

    public TextSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TextSelection selection) {
        this.selection = selection;
    }

    public String toString() {
        return "JsonOpenerOptions [selection=" + this.selection + "]";
    }

    public String toJson() {
        return JsonOpenerOptions.toJson(this);
    }

    public static String toJson(JsonOpenerOptions options) {
        return new Gson().toJson((Object)options);
    }

    public static Optional<JsonOpenerOptions> fromJson(String options) {
        try {
            return Optional.ofNullable((JsonOpenerOptions)new Gson().fromJson(options, JsonOpenerOptions.class));
        }
        catch (JsonSyntaxException exception) {
            LOGGER.error((Object)exception);
            return Optional.empty();
        }
    }

    public static class LinePosition {
        private int line;
        private int character;

        public LinePosition() {
        }

        public LinePosition(int line, int character) {
            this.line = line;
            this.character = character;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getCharacter() {
            return this.character;
        }

        public void setCharacter(int character) {
            this.character = character;
        }

        public String toString() {
            return "LinePosition [line=" + this.line + ", character=" + this.character + "]";
        }
    }

    public static class TextSelection {
        private LinePosition start;
        private LinePosition end;

        public TextSelection() {
        }

        public TextSelection(LinePosition start, LinePosition end) {
            this.start = start;
            this.end = end;
        }

        public LinePosition getStart() {
            return this.start;
        }

        public void setStart(LinePosition start) {
            this.start = start;
        }

        public LinePosition getEnd() {
            return this.end;
        }

        public void setEnd(LinePosition end) {
            this.end = end;
        }

        public String toString() {
            return "TextSelection [start=" + this.start + ", end=" + this.end + "]";
        }
    }
}

