/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.glsp.ide.editor.GLSPServerManager;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;

public class GLSPEditorRegistry {
    private static String EDITOR_INTEGRATION_EXTENSION_POINT = "org.eclipse.glsp.ide.editor";
    private static String SERVER_MANAGER_CLASS_ATTRIBUTE = "serverManagerClass";
    private static String GLSP_EDITOR_ID_ATTRIBUTE = "editorId";
    private final Map<String, GLSPServerManager> editorIdToServerManager = new HashMap<String, GLSPServerManager>();
    private final Map<String, GLSPDiagramComposite> clientIdtoDiagramComposite = new HashMap<String, GLSPDiagramComposite>();

    public GLSPEditorRegistry() {
        UIUtil.getActiveWorkbenchWindow().ifPresent(window -> window.getPartService().addPartListener((IPartListener2)new GLSPDiagramEditorPartListener()));
        this.obtainProvidersFromRegistry();
    }

    protected void obtainProvidersFromRegistry() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EDITOR_INTEGRATION_EXTENSION_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object classObject = element.createExecutableExtension(SERVER_MANAGER_CLASS_ATTRIBUTE);
                String editorId = element.getAttribute(GLSP_EDITOR_ID_ATTRIBUTE);
                if (classObject instanceof GLSPServerManager) {
                    GLSPServerManager serverManager = (GLSPServerManager)classObject;
                    serverManager.start();
                    this.editorIdToServerManager.put(editorId, serverManager);
                }
            }
            catch (Exception exception) {
                GLSPIdeEditorPlugin.error("Exception while obtaining registered converters", exception);
            }
            ++n2;
        }
    }

    public Optional<GLSPServerManager> getGLSPServerManager(GLSPDiagramEditor diagramEditor) {
        return this.getGLSPServerManager(diagramEditor.getEditorId());
    }

    public Optional<GLSPServerManager> getGLSPServerManager(GLSPDiagramComposite diagramComposite) {
        return this.getGLSPServerManager(diagramComposite.getEditorId());
    }

    public Optional<GLSPServerManager> getGLSPServerManager(String editorId) {
        return Optional.of(this.editorIdToServerManager.get(editorId));
    }

    public synchronized Optional<GLSPDiagramComposite> getGLSPEditor(String clientId) {
        return Optional.ofNullable(this.clientIdtoDiagramComposite.get(clientId));
    }

    public GLSPDiagramComposite getGLSPEditorOrThrow(String clientId) {
        return (GLSPDiagramComposite)GLSPServerException.getOrThrow(this.getGLSPEditor(clientId), (String)("Could not retrieve GLSP Editor. GLSP editor is not properly configured for clientId: " + clientId));
    }

    public void registerComposite(GLSPDiagramComposite diagram) {
        this.clientIdtoDiagramComposite.put(diagram.getClientId(), diagram);
    }

    private void partClosed(IWorkbenchPartReference part) {
        if (part.getPart(false) instanceof GLSPDiagramEditor) {
            GLSPDiagramEditor editor = (GLSPDiagramEditor)part.getPart(false);
            editor.notifyAboutToBeDisposed();
            this.removeDiagramEditor(editor.getClientId());
        }
    }

    private synchronized void partOpened(IWorkbenchPartReference part) {
        if (part.getPart(false) instanceof GLSPDiagramEditor) {
            GLSPDiagramEditor editor = (GLSPDiagramEditor)part.getPart(false);
            this.clientIdtoDiagramComposite.put(editor.getClientId(), editor.getDiagram());
        }
    }

    private synchronized void removeDiagramEditor(String clientID) {
        this.clientIdtoDiagramComposite.remove(clientID);
    }

    class GLSPDiagramEditorPartListener
    implements IPartListener2 {
        GLSPDiagramEditorPartListener() {
        }

        public void partClosed(IWorkbenchPartReference part) {
            GLSPEditorRegistry.this.partClosed(part);
        }

        public void partOpened(IWorkbenchPartReference part) {
            GLSPEditorRegistry.this.partOpened(part);
        }
    }
}

