/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Control;

public class ChromiumSelectionFunction {
    private static final String FUNCTION_NAME = "mouseDownHappened";
    private static final String INSTALL_FUNCTION = "document.onmousedown = function(e) {if (!e) {e = window.event;} if (e) {mouseDownHappened();}}";
    private BrowserFunction browserFunction;

    public ChromiumSelectionFunction(GLSPDiagramEditor editor, final Browser browser) {
        this.browserFunction = new BrowserFunction(browser, FUNCTION_NAME){

            public Object function(Object[] arguments) {
                browser.getDisplay().asyncExec(() -> {
                    String osName = System.getProperty("os.name").toLowerCase();
                    if (osName.contains("win")) {
                        browser.forceFocus();
                    } else {
                        Control focusControl = browser.getDisplay().getFocusControl();
                        if (Objects.equals(focusControl, browser)) {
                            return;
                        }
                        browser.setFocus();
                        focusControl = browser.getDisplay().getFocusControl();
                        if (focusControl != browser) {
                            browser.forceFocus();
                        }
                    }
                });
                return null;
            }
        };
    }

    public BrowserFunction getBrowserFunction() {
        return this.browserFunction;
    }

    public static Optional<BrowserFunction> install(GLSPDiagramEditor editor, Browser browser) {
        if ((browser.getStyle() & 0x20000) == 0) {
            return Optional.empty();
        }
        ChromiumSelectionFunction function = new ChromiumSelectionFunction(editor, browser);
        browser.execute(INSTALL_FUNCTION);
        return Optional.of(function.getBrowserFunction());
    }
}

