/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.glsp.ide.editor.DiagramWebsocketEndpoint;
import org.eclipse.glsp.ide.editor.internal.utils.SystemUtils;
import org.eclipse.glsp.server.di.ServerModule;
import org.eclipse.glsp.server.websocket.GLSPConfigurator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public abstract class GLSPServerManager {
    protected Server server;
    protected ServerContainer container;
    protected Injector injector;
    protected int localPort;

    public synchronized void start() throws Exception {
        if (this.server == null || !this.server.isRunning()) {
            this.server = new Server(new InetSocketAddress("localhost", 0));
            this.configure(this.server);
            this.server.start();
            this.localPort = Arrays.stream(this.server.getConnectors()).findFirst().map(ServerConnector.class::cast).map(ServerConnector::getLocalPort).orElse(-1);
        }
    }

    public abstract String getGlspId();

    public abstract URL getResourceURL();

    protected void configure(Server server) throws URISyntaxException, IOException, ServletException, DeploymentException {
        BasicConfigurator.configure();
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        ServletHolder defaultServletHolder = new ServletHolder("default", (Servlet)new DefaultServlet());
        String resourceBase = this.resolveResourceBase();
        defaultServletHolder.setInitParameter("resourceBase", resourceBase);
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        context.addServlet(defaultServletHolder, "/");
        this.container = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
        this.container.setDefaultMaxSessionIdleTimeout(TimeUnit.MINUTES.toMillis(10L));
        ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(DiagramWebsocketEndpoint.class, (String)("/" + this.getGlspId()));
        Injector injector = this.createInjector();
        builder.configurator((ServerEndpointConfig.Configurator)new GLSPConfigurator(() -> injector));
        this.container.addEndpoint(builder.build());
    }

    protected abstract ServerModule configureServerModule();

    protected List<Module> configureAdditionalModules() {
        return Collections.emptyList();
    }

    protected Injector createInjector() {
        ArrayList<ServerModule> modules = new ArrayList<ServerModule>();
        modules.add(this.configureServerModule());
        this.configureAdditionalModules().forEach(modules::add);
        return Guice.createInjector(modules);
    }

    protected String resolveResourceBase() throws IOException {
        String resourceBase = FileLocator.resolve((URL)this.getResourceURL()).getFile();
        if (SystemUtils.isWindows() && resourceBase.startsWith("/")) {
            resourceBase = resourceBase.substring(1);
        }
        return resourceBase;
    }

    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Optional<Session> getSessionFor(String clientId) {
        return this.container.getOpenSessions().stream().filter(s -> s.getUserProperties().get("clientId") != null && s.getUserProperties().get("clientId").equals(clientId)).findFirst();
    }

    public Server getServer() {
        return this.server;
    }

    public int getLocalPort() {
        return this.localPort;
    }
}

