/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.glsp.ide.editor.IdeGLSPClient;
import org.eclipse.glsp.ide.editor.IdeMessageConsumer;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.websocket.GLSPServerEndpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.ui.statushandlers.StatusManager;

public class DiagramWebsocketEndpoint
extends GLSPServerEndpoint {
    protected Timer timer;
    protected GLSPClient glspClient;
    @Inject
    protected IdeGLSPClient ideGLSPClient;

    public void onError(Session session, Throwable throwable) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.glsp.ide.editor", "Error in diagram web socket", throwable));
        super.onError(session, throwable);
    }

    protected Function<MessageConsumer, MessageConsumer> messageWrapper() {
        return msg -> new IdeMessageConsumer(this.ideGLSPClient, () -> this.glspClient, (MessageConsumer)msg);
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.ideGLSPClient.disconnect(this.glspClient);
    }

    protected void connect(Collection<Object> localServices, final GLSPClient remoteProxy) {
        this.glspClient = remoteProxy;
        this.glspServer.connect((GLSPClient)this.ideGLSPClient);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                remoteProxy.process(new ActionMessage("", (Action)new KeepAliveAction()));
            }
        }, 0L, TimeUnit.MINUTES.toMillis(2L));
    }

    public static final class KeepAliveAction
    extends Action {
        private KeepAliveAction() {
            super("keepAlive");
        }
    }
}

