/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx.cellmarkers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.xlsx.CellRef;
import org.eclipse.gendoc.document.parser.xlsx.XLSXParser;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.AbstractCellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellMark;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ICellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.helper.XPathXlsxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CellRangeRefMarker
extends AbstractCellRefMarker
implements ICellRefMarker {
    protected final String attrPath;
    protected final String parentCountAttrPath;
    private Map<String, List<CellMark>[]> markRanges;

    public CellRangeRefMarker(String mark, String xpath, String attrPath) {
        super(mark, xpath);
        this.attrPath = attrPath;
        this.parentCountAttrPath = null;
    }

    public CellRangeRefMarker(String mark, String relationType, String xpath, String attrPath) {
        super(mark, relationType, xpath);
        this.attrPath = attrPath;
        this.parentCountAttrPath = null;
    }

    public CellRangeRefMarker(String mark, String relationType, String xpath, String attrPath, String parentCountAttrPath) {
        super(mark, relationType, xpath);
        this.attrPath = attrPath;
        this.parentCountAttrPath = parentCountAttrPath;
    }

    @Override
    public List<CellMark> getAppliedMarks(XLSXParser xlsxParser) {
        List<CellMark> marks = super.getAppliedMarks(xlsxParser);
        this.markRanges = this.calculateMarkRanges(marks);
        return marks;
    }

    protected Map<String, List<CellMark>[]> calculateMarkRanges(List<CellMark> marks) {
        int maxKind = 2;
        for (CellMark m : marks) {
            int kind = Integer.valueOf(m.kind);
            maxKind = Math.max(maxKind, kind);
        }
        LinkedHashMap<String, List<CellMark>[]> ranges = new LinkedHashMap<String, List<CellMark>[]>();
        for (CellMark m : marks) {
            List[] markRange = (List[])ranges.get(m.path);
            if (markRange == null) {
                markRange = new List[maxKind];
                int i = 0;
                while (i < maxKind) {
                    markRange[i] = new ArrayList();
                    ++i;
                }
                ranges.put(m.path, markRange);
            }
            int kind = Integer.valueOf(m.kind);
            markRange[kind].add(m);
        }
        return ranges;
    }

    @Override
    public List<CellMark> getMarksToApply(XLSXParser xlsxParser) {
        XLSXParser parser = xlsxParser;
        if (this.relationType != null) {
            try {
                parser = xlsxParser.loadImplicitPartDocument(this.relationType);
                if (parser == null) {
                    return Collections.EMPTY_LIST;
                }
            }
            catch (IOException e) {
                return Collections.EMPTY_LIST;
            }
        }
        try {
            ArrayList<CellMark> marks = new ArrayList<CellMark>();
            NodeList nl = this.evaluateNodes(parser);
            XPathExpression attrXpath = XPathXlsxUtils.compile(this.attrPath);
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(0);
                String references = attrXpath.evaluate(el);
                String[] items = references.split("\\s+");
                int nCount = 0;
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String ref = stringArray[n2];
                    if (!ref.contains(":")) {
                        ref = String.valueOf(ref) + ":" + ref;
                    }
                    String elXPath = XPathXlsxUtils.getNodeXPath(el);
                    String[] parts = ref.split(":");
                    marks.add(this.createMark(xlsxParser, new CellRef(parts[nCount + 0]), this.relationType, elXPath, nCount));
                    marks.add(this.createMark(xlsxParser, new CellRef(parts[nCount + 1]), this.relationType, elXPath, nCount + 1));
                    nCount += 2;
                    ++n2;
                }
                ++i;
            }
            return marks;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected NodeList evaluateNodes(XMLParser xlsxParser) throws XPathExpressionException {
        return XPathXlsxUtils.evaluateNodes(xlsxParser.getDocument(), String.valueOf(this.xpath) + "[" + this.attrPath + "]");
    }

    @Override
    public void layoutCellReference(XLSXParser xlsxParser, CellRef source, List<CellMark> targets) {
        if (targets == null || targets.isEmpty()) {
            return;
        }
        XLSXParser parser = xlsxParser;
        if (this.relationType != null) {
            try {
                parser = xlsxParser.loadImplicitPartDocument(this.relationType);
                if (parser == null) {
                    return;
                }
            }
            catch (IOException e) {
                return;
            }
        }
        CellMark first = targets.get(0);
        List<CellMark>[] marks = this.markRanges.get(first.path);
        if (marks == null) {
            return;
        }
        this.markRanges.remove(first.path);
        int r = 0;
        while (r < marks.length) {
            int nCount = 0;
            try {
                XPathExpression attrXpath = XPathXlsxUtils.compile(this.attrPath);
                Node nodeRef = null;
                int nMarks = Math.min(marks[r + 0].size(), marks[r + 1].size());
                int i = 0;
                while (i < nMarks) {
                    Element firstEl = this.getTargetElement(xlsxParser, first);
                    if (firstEl == null) {
                        return;
                    }
                    Element el = firstEl;
                    if (i != 0) {
                        el = (Element)firstEl.cloneNode(true);
                        firstEl.getParentNode().insertBefore(el, nodeRef);
                        ++nCount;
                    } else {
                        nodeRef = firstEl.getNextSibling();
                    }
                    Node n = (Node)attrXpath.evaluate(el, XPathConstants.NODE);
                    if (n != null) {
                        n.setNodeValue(String.valueOf(marks[r + 0].get((int)i).cell.getRef()) + ":" + marks[r + 1].get((int)i).cell.getRef());
                    }
                    ++i;
                }
                if (this.parentCountAttrPath != null) {
                    Node n = XPathXlsxUtils.evaluateNode(parser.getDocument(), String.valueOf(first.path) + "/" + this.parentCountAttrPath);
                    n.setNodeValue(String.valueOf(nCount += Integer.valueOf(n.getNodeValue()).intValue()));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            r += 2;
        }
    }
}

