/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.html.files;

import org.eclipse.gendoc.bundle.acceleo.html.files.IHtmlVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class HtmlStripTagVisitor
implements IHtmlVisitor {
    protected StringBuilder buf = new StringBuilder();

    public String toString() {
        return this.buf.toString();
    }

    @Override
    public void visitText(Text node) {
        this.buf.append(node.getNodeValue());
    }

    @Override
    public void visitElementAfter(Element node) {
        String tag = node.getTagName();
        if (tag.equals("p")) {
            this.newLine();
        } else if (tag.equals("li") && !this.isStartingLine()) {
            this.newLine();
        }
    }

    @Override
    public boolean visitElement(Element node) {
        String tag = node.getTagName();
        if (tag.equals("p")) {
            if (!this.isStartingLine()) {
                this.newLine();
            }
        } else if (tag.equals("br")) {
            this.newLine();
            return false;
        }
        if ((tag.equals("ol") || tag.equals("ul")) && !this.isStartingLine()) {
            this.newLine();
        }
        return true;
    }

    @Override
    public void visitDocumentAfter(Document node) {
    }

    @Override
    public boolean visitDocument(Document node) {
        return true;
    }

    protected void newLine() {
        this.buf.append("\n");
    }

    protected boolean isStartingLine() {
        int pos = this.buf.length();
        if (pos == 0) {
            return true;
        }
        --pos;
        while (pos >= 0) {
            char ch = this.buf.charAt(pos);
            if (ch == '\n' || ch == '\r' || ch == '\u000e') {
                return true;
            }
            if (!Character.isWhitespace(ch)) {
                return false;
            }
            --pos;
        }
        return true;
    }
}

