/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.tags.handlers.impl.config.IDeferredParameterValue;
import org.eclipse.gendoc.tags.handlers.impl.config.IDeferredValue;

public class DefaultParameterValue
implements IDeferredParameterValue {
    private static final String KEY_INPUT = "input";
    private static final String KEY_INPUT_EXT = "input_ext";
    private static final String KEY_INPUT_DIRECTORY = "input_directory";
    private static final String KEY_DATE = "date";

    @Override
    public Map<String, String> getValue() {
        HashMap<String, String> result = new HashMap<String, String>();
        Date actual = Calendar.getInstance().getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        result.put(KEY_DATE, format.format(actual));
        return result;
    }

    @Override
    public Map<String, IDeferredValue> getDeferredValues() {
        HashMap<String, IDeferredValue> result = new HashMap<String, IDeferredValue>();
        IDeferredValue documentDeferred = new IDeferredValue(){

            @Override
            public String get() {
                String document = DefaultParameterValue.this.getDocument();
                return document.substring(0, document.lastIndexOf("."));
            }
        };
        result.put(KEY_INPUT, documentDeferred);
        IDeferredValue documentDeferred2 = new IDeferredValue(){

            @Override
            public String get() {
                String document = DefaultParameterValue.this.getDocument();
                return document;
            }
        };
        result.put(KEY_INPUT_EXT, documentDeferred2);
        IDeferredValue documentDeferred3 = new IDeferredValue(){

            @Override
            public String get() {
                IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
                String pathFile = docService.getDocument().getPath().substring(0, docService.getDocument().getPath().lastIndexOf(47));
                return pathFile;
            }
        };
        result.put(KEY_INPUT_DIRECTORY, documentDeferred3);
        return result;
    }

    private String getDocument() {
        try {
            IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
            if (docService != null) {
                String name = docService.getDocument().getPath().substring(docService.getDocument().getPath().lastIndexOf(47) + 1);
                return name;
            }
        }
        catch (RuntimeException runtimeException) {}
        return "";
    }
}

