/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.xlsx;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.gendoc.document.parser.documents.AbstractZipDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.helper.OfficeHelper;
import org.w3c.dom.Node;

public class XLSXDocument
extends AbstractZipDocument {
    private static final String SHEET_NODE = "sheet";
    private static final String NEW_CELL_NODE = "si";
    private static final String TEXT_VALUE_NODE = "t";
    private String[] strings = null;

    public XLSXDocument(File documentFile) throws IOException {
        this(documentFile.toURI().toURL(), null);
    }

    public XLSXDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws IOException {
        this(documentFile.toURI().toURL(), configuration);
    }

    public XLSXDocument(URL documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(documentFile, configuration);
        this.initStrings();
    }

    private void initStrings() {
        XMLParser parser = new XMLParser(this.getUnzipper().getFile("sharedStrings.xml"));
        Node item = parser.getCurrentNode().getAttributes().getNamedItem("uniqueCount");
        if (item == null) {
            return;
        }
        int nb = Integer.valueOf(item.getTextContent());
        this.strings = new String[nb];
        int i = -1;
        do {
            String nodeName;
            if (NEW_CELL_NODE.equals(nodeName = parser.getCurrentNode().getNodeName())) {
                ++i;
            }
            if (!TEXT_VALUE_NODE.equals(nodeName)) continue;
            String text = parser.getCurrentNode().getTextContent();
            this.strings[i] = this.strings[i] != null ? this.strings[i].concat(text) : text;
        } while (parser.next());
    }

    @Override
    protected Collection<XMLParser> getXmlParsers(Document.CONFIGURATION idForDocument) {
        LinkedList<XMLParser> parsers = new LinkedList<XMLParser>();
        switch (idForDocument) {
            case content: {
                XMLParser workbook = new XMLParser(this.getUnzipper().getFile("workbook.xml"), idForDocument);
                do {
                    Node item;
                    if (!SHEET_NODE.equals(workbook.getCurrentNode().getNodeName()) || (item = workbook.getCurrentNode().getAttributes().getNamedItem("r:id")) == null) continue;
                    OfficeHelper.fillCollection(this.getUnzipper(), parsers, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet", idForDocument, "workbook.xml.rels", item.getTextContent());
                } while (workbook.next());
                break;
            }
            case footer: {
                break;
            }
        }
        return parsers;
    }

    public String getStyle() {
        return "";
    }

    public String getText() {
        String result = "";
        Node currentNode = this.getXMLParser().getCurrentNode();
        if ("c".equals(currentNode.getNodeName())) {
            Node item = currentNode.getAttributes().getNamedItem(TEXT_VALUE_NODE);
            int i = 0;
            while (i < currentNode.getChildNodes().getLength()) {
                if ("v".equals(currentNode.getChildNodes().item(i).getNodeName())) {
                    String value = currentNode.getChildNodes().item(i).getTextContent();
                    if (item != null && "s".equals(item.getTextContent())) {
                        try {
                            int index = Integer.valueOf(value);
                            if (index >= this.strings.length) break;
                            result = this.strings[index];
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    result = value;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public String getTextCorrespondingToCurrentStyle() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        String[] columnArray;
        Node item;
        int column = -1;
        Node currentNode = this.getXMLParser().getCurrentNode();
        if ("c".equals(currentNode.getNodeName()) && (item = currentNode.getAttributes().getNamedItem("r")) != null && (columnArray = item.getTextContent().split("\\d")).length > 0) {
            String columnString = columnArray[0];
            column = this.getColumnNumber(columnString);
        }
        return column;
    }

    private int getColumnNumber(String columnString) {
        if (columnString == null || columnString.length() == 0) {
            return -1;
        }
        int finalValue = 0;
        int j = 0;
        int i = columnString.length() - 1;
        while (i >= 0) {
            finalValue = (int)((double)finalValue + (double)this.getColumnNumber(columnString.charAt(i)) * Math.pow(26.0, j));
            ++j;
            --i;
        }
        return finalValue - 1;
    }

    private int getColumnNumber(char charAt) {
        return charAt - 65 + 1;
    }

    @Override
    public Object get(Document.PROPERTY property) {
        switch (property) {
            case row: {
                return this.getRowNumber();
            }
            case column: {
                return this.getColumnNumber();
            }
            case text: {
                return this.getText();
            }
        }
        return null;
    }

    private int getRowNumber() {
        return 0;
    }
}

