/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.acceleo.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gendoc.m2t.model.Argument;
import org.eclipse.gendoc.m2t.model.Fragment;
import org.eclipse.gendoc.script.acceleo.ServicesExtension;
import org.eclipse.gendoc.script.acceleo.impl.ScriptGenerator;
import org.eclipse.gendoc.services.exception.GenDocException;

public class FragmentScriptGenerator
extends ScriptGenerator {
    private final Fragment f;

    public FragmentScriptGenerator(List<Pattern> patterns, Fragment f) {
        super(patterns);
        this.f = f;
    }

    @Override
    protected void addImports(EObject element, StringBuilder resultScript) throws GenDocException {
        for (String bundle : this.getImportedBundlesForScript()) {
            this.addImport(element, resultScript, bundle);
        }
        for (String fragmentImported : this.f.getImportedFragments()) {
            super.addImport(element, resultScript, fragmentImported);
        }
    }

    @Override
    protected boolean addModuleImport() {
        return true;
    }

    @Override
    protected void appendModuleName(StringBuilder resultScript) {
        resultScript.append(this.f.getName());
    }

    @Override
    protected String getTemplateName() {
        return this.f.getName();
    }

    @Override
    protected List<String> getImportedBundlesForScript() {
        LinkedList<String> importedBundles = new LinkedList<String>(this.f.getImportedBundles());
        for (String bundleName : ServicesExtension.getInstance().getBundlesImportedByDefault()) {
            if (importedBundles.contains(bundleName)) continue;
            importedBundles.add(bundleName);
        }
        return importedBundles;
    }

    @Override
    protected boolean generatesFile() {
        return false;
    }

    @Override
    protected String getTemplateArguments(EObject element) {
        StringBuffer result = new StringBuffer();
        boolean flag = false;
        for (Argument a : this.f.getArguments()) {
            if (flag) {
                result.append(", ");
            }
            result.append(a.getName()).append(" : ").append(a.getType());
            flag = true;
        }
        return result.toString();
    }

    @Override
    protected String getTemplateVisibility() {
        return "public";
    }
}

