/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.post;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractStepProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.w3c.dom.Node;

public class DropTagProcess
extends AbstractStepProcess {
    protected static final Pattern DROP_TAG_PATTERN = Pattern.compile("<\\s*" + RegisteredTags.DROP + "\\s*/\\s*>", 8);
    protected IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
    protected LinkedList<Node> nodesToRemove;

    protected void doRun() throws GenDocException {
        this.nodesToRemove = new LinkedList();
        super.doRun();
        for (Node n : this.nodesToRemove) {
            Node parent = n.getParentNode();
            if (parent == null) continue;
            parent.removeChild(n);
        }
    }

    protected void step(Document document) throws GenDocException {
        String text;
        Node currentNode = document.getXMLParser().getCurrentNode();
        if (this.documentService.isPara(currentNode.getNodeName()) && (text = (String)document.get(Document.PROPERTY.text)) != null && DROP_TAG_PATTERN.matcher(text).find()) {
            this.nodesToRemove.add(currentNode);
        }
    }
}

