/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.tags.IAttributeExtension;
import org.eclipse.gendoc.tags.TagsExtensionPoint;
import org.eclipse.gendoc.tags.impl.AbstractExtension;

public class AttributeExtension
extends AbstractExtension
implements IAttributeExtension {
    private final String name;
    private final String typeName;
    private final boolean required;
    private final String defaultValue;

    public static AttributeExtension load(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TagsExtensionPoint.ATTRIBUTE)) {
            return null;
        }
        try {
            AttributeExtension attributeExtension = new AttributeExtension(configElement);
            return attributeExtension;
        }
        catch (Exception e) {
            String message = "Failed to load " + TagsExtensionPoint.TAG + " in " + configElement.getDeclaringExtension().getNamespaceIdentifier();
            AbstractExtension.log(message, e);
            return null;
        }
    }

    protected AttributeExtension(IConfigurationElement configElement) {
        super(configElement);
        this.name = AttributeExtension.parseStringAttribute(configElement, TagsExtensionPoint.ATTRIBUTE_NAME, true);
        this.typeName = AttributeExtension.parseStringAttribute(configElement, TagsExtensionPoint.ATTRIBUTE_TYPE, true);
        this.required = AttributeExtension.parseBooleanAttribute(configElement, TagsExtensionPoint.ATTRIBUTE_REQUIRED, true);
        this.defaultValue = AttributeExtension.parseStringAttribute(configElement, TagsExtensionPoint.ATTRIBUTE_DEFAULT, false);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isRequired() {
        return this.required;
    }
}

