/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.IService;
import org.eclipse.gendoc.services.ServiceExtension;
import org.eclipse.gendoc.services.ServiceTypeExtension;
import org.eclipse.gendoc.services.ServiceTypesExtensionPoint;
import org.eclipse.gendoc.services.ServicesExtensionPoint;
import org.eclipse.gendoc.services.exception.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GendocServices {
    private static GendocServices instance = new GendocServices();
    private final Thread initThread;
    private boolean initialized = false;
    private final Map<Class<? extends IService>, String> serviceIds = new HashMap<Class<? extends IService>, String>();
    private final Map<String, IService> services = new HashMap<String, IService>();

    public static GendocServices getDefault() {
        return instance;
    }

    private GendocServices() {
        this.initThread = Thread.currentThread();
    }

    public void clear() {
        ServiceTypesExtensionPoint.getDefault().clear();
        ServicesExtensionPoint.getDefault().clear();
        for (IService service : this.services.values()) {
            service.clear();
        }
        this.services.clear();
        this.serviceIds.clear();
        this.initialized = false;
    }

    public <T extends IService> T getService(Class<? extends IService> serviceType) {
        IService service = null;
        if (!this.initialized) {
            this.initialize();
        }
        try {
            service = Thread.currentThread() == this.initThread ? this.doGetService(serviceType) : (IService)this.doGetSynchronizedService(serviceType);
            return (T)service;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Error getting service for serviceType (" + serviceType.getName() + ")", e);
        }
    }

    public void setService(Class<? extends IService> serviceType, IService service) {
        String serviceId;
        if (serviceType.isInstance(service)) {
            serviceId = service.getServiceId();
            if (serviceId == null) {
                throw new RuntimeException("Service of type '" + serviceType.getName() + " has a null id.");
            }
        } else {
            throw new RuntimeException("Service id='" + service.getServiceId() + "' is not an instance of " + serviceType.getName() + ".");
        }
        this.serviceIds.put(serviceType, serviceId);
        this.services.put(serviceId, service);
    }

    public void setService(String serviceId) {
        if (!this.initialized) {
            this.initialize();
        }
        this.setServiceId(this.getServiceType(serviceId), serviceId);
    }

    private IService createService(Class<? extends IService> serviceType, String serviceId) {
        IService service = null;
        ServiceExtension serviceExtension = ServicesExtensionPoint.getDefault().getServiceExtension(serviceId);
        if (serviceExtension != null) {
            service = serviceExtension.getService();
            ServiceTypeExtension serviceTypeExtension = serviceExtension.getServiceType();
            Class<? extends IService> serviceTypeInterface = serviceTypeExtension.getInterface();
            if (!serviceTypeInterface.isInstance(service)) {
                throw new RuntimeException("Service '" + serviceId + "' is not an instance of the interface '" + serviceTypeInterface.getName() + "' required for service type '" + serviceTypeExtension.getId() + "'.");
            }
        }
        if (service == null) {
            throw new RuntimeException("Service '" + serviceId + "' is null.");
        }
        return service;
    }

    private IService doGetService(Class<? extends IService> serviceType) {
        String serviceId;
        ILogger logger = null;
        if (!ILogger.class.equals(serviceType)) {
            logger = (ILogger)this.getService(ILogger.class);
        }
        if ((serviceId = this.serviceIds.get(serviceType)) == null) {
            throw new RuntimeException("No service has been selected for service type " + serviceType.getName() + ".");
        }
        IService service = this.services.get(serviceId);
        if (service == null) {
            service = this.createService(serviceType, serviceId);
            this.services.put(serviceId, service);
            if (logger != null) {
                logger.log("Service '" + serviceType + "' : " + service.getClass().getName(), 16);
            }
        }
        return service;
    }

    private synchronized Object doGetSynchronizedService(Class<? extends IService> serviceType) {
        ((ILogger)this.doGetService(ILogger.class)).log("Synchronized way", 16);
        return this.doGetService(serviceType);
    }

    private Class<? extends IService> getServiceType(String serviceId) {
        ServiceExtension serviceExtension = ServicesExtensionPoint.getDefault().getServiceExtension(serviceId);
        return serviceExtension.getServiceType().getInterface();
    }

    private void initialize() {
        this.clear();
        for (ServiceTypeExtension serviceTypeExtension : ServiceTypesExtensionPoint.getDefault().getServiceTypeExtensions()) {
            try {
                String serviceId = serviceTypeExtension.getDefaultServiceExtension().getId();
                this.serviceIds.put(serviceTypeExtension.getInterface(), serviceId);
            }
            catch (ServiceException e) {
                ((ILogger)this.doGetService(ILogger.class)).log("No default service found for service type '" + serviceTypeExtension.getId() + "'.", 2);
                e.printStackTrace();
            }
        }
        this.initialized = true;
    }

    private void setServiceId(Class<? extends IService> serviceType, String serviceId) {
        this.serviceIds.put(serviceType, serviceId);
    }
}

