/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.builder;

import org.eclipse.ajdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.util.Util;

class ClasspathMultiDirectory
extends ClasspathDirectory {
    IContainer sourceFolder;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;
    boolean hasIndependentOutputFolder;

    ClasspathMultiDirectory(IContainer sourceFolder, IContainer binaryFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        super(binaryFolder, true, null);
        this.sourceFolder = sourceFolder;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.hasIndependentOutputFolder = false;
        if (this.inclusionPatterns != null && this.inclusionPatterns.length == 0) {
            this.inclusionPatterns = null;
        }
        if (this.exclusionPatterns != null && this.exclusionPatterns.length == 0) {
            this.exclusionPatterns = null;
        }
    }

    @Override
    public int hashCode() {
        int num1 = this.sourceFolder == null ? 0 : this.sourceFolder.hashCode();
        int num2 = this.inclusionPatterns == null ? 0 : CharOperation.toString((char[][])this.inclusionPatterns).hashCode();
        int num3 = this.exclusionPatterns == null ? 0 : CharOperation.toString((char[][])this.exclusionPatterns).hashCode();
        return num1 * num2 * num3;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathMultiDirectory)) {
            return false;
        }
        ClasspathMultiDirectory md = (ClasspathMultiDirectory)o;
        return this.sourceFolder.equals((Object)md.sourceFolder) && this.binaryFolder.equals((Object)md.binaryFolder) && CharOperation.equals((char[][])this.inclusionPatterns, (char[][])md.inclusionPatterns) && CharOperation.equals((char[][])this.exclusionPatterns, (char[][])md.exclusionPatterns);
    }

    protected boolean isExcluded(IResource resource) {
        if ((this.exclusionPatterns != null || this.inclusionPatterns != null) && this.sourceFolder.equals((Object)this.binaryFolder)) {
            return Util.isExcluded((IResource)resource, (char[][])this.inclusionPatterns, (char[][])this.exclusionPatterns);
        }
        return false;
    }

    @Override
    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString() + " with binary directory " + this.binaryFolder.getFullPath().toString();
    }
}

