/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.IAJCodeElement;
import org.eclipse.ajdt.core.javaelements.SourceRange;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.util.Util;

public class AJCodeElement
extends LocalVariable
implements IAJCodeElement {
    private String name;
    private int startLine;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public AJCodeElement(JavaElement parent, String name) {
        super(parent, name, 0, 0, 0, 0, "I", new Annotation[0], 0, false);
        this.name = name;
    }

    public AJCodeElement(JavaElement parent, String name, int occurrence) {
        this(parent, name);
        this.occurrenceCount = occurrence;
    }

    public ISourceRange getNameRange() {
        if (this.nameStart == 0) {
            this.initializeLocations();
        }
        return new SourceRange(this.nameStart, this.nameEnd - this.nameStart + 1);
    }

    public int hashCode() {
        return Util.combineHashCodes((int)this.name.hashCode(), (int)this.occurrenceCount);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AJCodeElement)) {
            return super.equals(o);
        }
        AJCodeElement ajce = (AJCodeElement)o;
        return super.equals(o) && this.occurrenceCount == ajce.occurrenceCount;
    }

    public void initializeLocations() {
        IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement(this).javaElementToProgramElement(this);
        ISourceLocation sloc = ipe.getSourceLocation();
        if (sloc != null) {
            this.startLine = sloc.getLine();
            this.nameStart = sloc.getOffset();
            if (sloc instanceof EclipseSourceLocation) {
                EclipseSourceLocation esloc = (EclipseSourceLocation)sloc;
                this.nameEnd = esloc.getEndPos();
            }
        }
        if (this.nameStart <= 0 || this.nameEnd <= 0) {
            try {
                IBuffer buffer;
                IOpenable openable = this.parent.getOpenableParent();
                if (openable instanceof AJCompilationUnit) {
                    AJCompilationUnit ajCompUnit = (AJCompilationUnit)openable;
                    ajCompUnit.requestOriginalContentMode();
                    buffer = openable.getBuffer();
                    ajCompUnit.discardOriginalContentMode();
                } else {
                    buffer = openable.getBuffer();
                }
                String source = buffer.getContents();
                int lines = 0;
                int i = 0;
                while (i < source.length()) {
                    if (source.charAt(i) == '\n' && ++lines == this.startLine - 1) {
                        ++i;
                        while (i < source.length() && Character.isWhitespace(source.charAt(i)) && source.charAt(i) != '\n') {
                            ++i;
                        }
                        this.nameStart = i;
                        break;
                    }
                    ++i;
                }
                i = this.nameStart + 1;
                while (i < source.length()) {
                    if (source.charAt(i) == '\n' || source.charAt(i) == ';') {
                        this.nameEnd = i - 1;
                        break;
                    }
                    ++i;
                }
                this.nameStart = Math.min(this.nameStart, this.nameEnd);
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
    }

    public int getLine() {
        return this.startLine;
    }

    public String getName() {
        return this.name;
    }

    protected char getHandleMementoDelimiter() {
        return '?';
    }

    public IJavaElement[] getChildren() {
        return JavaElement.NO_ELEMENTS;
    }

    static {
        AJCodeElement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJCodeElement.java", AJCodeElement.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.AJCodeElement", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 123);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "initializeLocations", "org.eclipse.ajdt.core.javaelements.AJCodeElement", "", "", "", "void"), 67);
    }
}

