/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.utils.ui.widgets;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LabelEditorDialog
extends Dialog {
    protected IDocument parameterLabelDocument;
    protected String title;
    protected String value = "";
    protected IInputValidator validator;
    protected Button okButton;
    protected Text errorMessageText;
    protected String errorMessage;
    protected SourceViewer viewer = null;

    public LabelEditorDialog(Shell parentShell, String dialogTitle, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 && this.viewer != null ? this.viewer.getDocument().get() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected SourceViewer getSourceViewer() {
        return this.viewer;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null && this.viewer != null) {
            errorMessage = this.validator.isValid(this.viewer.getDocument().get());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled("".equals(errorMessage));
            }
        }
    }
}

