/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.priorities;

import fr.inria.aoste.timesquare.ccslkernel.model.utils.CCSLKernelUtils;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.SolverPriorityRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.model.ccslpriority.PriorityRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.model.ccslpriority.PrioritySpecification;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SolverPrioritySpecification {
    private Resource _resource = null;
    private CCSLKernelSolver _solver = null;
    private Set<SolverPriorityRelation> _priorityRelations = new HashSet<SolverPriorityRelation>();

    public Set<SolverPriorityRelation> getPriorityRelations() {
        return this._priorityRelations;
    }

    public SolverPrioritySpecification(SolverPrioritySpecification origin) {
        for (SolverPriorityRelation pr : origin.getPriorityRelations()) {
            this._priorityRelations.add(pr);
        }
    }

    public SolverPrioritySpecification(String pathName, CCSLKernelSolver solver) {
        this._solver = solver;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this._resource = resourceSet.createResource(URI.createFileURI((String)pathName));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        PrioritySpecification spec = (PrioritySpecification)this._resource.getContents().get(0);
        for (PriorityRelation relation : spec.getRelations()) {
            SolverPriorityRelation r = new SolverPriorityRelation();
            r.setLower(this._solver.findClockByPath(this.getQualifiedName((EObject)relation.getLower())));
            r.setHigher(this._solver.findClockByPath(this.getQualifiedName((EObject)relation.getHigher())));
            this._priorityRelations.add(r);
        }
    }

    public SolverPrioritySpecification(Resource resource, CCSLKernelSolver solver) {
        this._solver = solver;
        this._resource = resource;
        ResourceSet resourceSet = resource.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        PrioritySpecification spec = (PrioritySpecification)this._resource.getContents().get(0);
        for (PriorityRelation relation : spec.getRelations()) {
            SolverPriorityRelation r = new SolverPriorityRelation();
            r.setLower(this._solver.findClockByPath(this.getQualifiedName((EObject)relation.getLower())));
            r.setHigher(this._solver.findClockByPath(this.getQualifiedName((EObject)relation.getHigher())));
            this._priorityRelations.add(r);
        }
    }

    public SolverPrioritySpecification(PrioritySpecification specModel, CCSLKernelSolver solver) {
        PrioritySpecification spec = specModel;
        for (PriorityRelation relation : spec.getRelations()) {
            SolverPriorityRelation r = new SolverPriorityRelation();
            r.setLower(this._solver.findClockByPath(this.getQualifiedName((EObject)relation.getLower())));
            r.setHigher(this._solver.findClockByPath(this.getQualifiedName((EObject)relation.getHigher())));
            this._priorityRelations.add(r);
        }
    }

    private String getQualifiedName(EObject eo) {
        return CCSLKernelUtils.getQualifiedName((EObject)eo);
    }

    public Set<RuntimeClock> removeLowerPrio(RuntimeClock sc, Set<RuntimeClock> result2) {
        Set<RuntimeClock> result = new HashSet<RuntimeClock>(result2);
        for (SolverPriorityRelation r : this._priorityRelations) {
            if (r.higher != sc) continue;
            result.remove(r.lower);
            result = this.removeLowerPrio(r.lower, result);
        }
        return result;
    }

    public Set<RuntimeClock> removeLowerPrio(Set<RuntimeClock> eSet) {
        Set<RuntimeClock> result = new HashSet<RuntimeClock>(eSet);
        for (RuntimeClock sc : result) {
            result = this.removeLowerPrio(sc, result);
        }
        return result;
    }

    public boolean add(SolverPriorityRelation newPR) {
        SolverClock lower = newPR.getLower();
        SolverClock higher = newPR.getHigher();
        for (SolverPriorityRelation pr : this._priorityRelations) {
            if (!pr.getLower().equals(lower) || !pr.getHigher().equals(higher)) continue;
            return false;
        }
        this._priorityRelations.add(newPR);
        return true;
    }
}

