/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver;

import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

@Deprecated
public class ClockDeathSolver {
    private HashSet<RuntimeClock> deadClocks = new HashSet();
    private HashMap<RuntimeClock, Set<RuntimeClock>> implications = new HashMap();
    private Vector<Set<RuntimeClock>> equalityClasses = new Vector();
    private HashMap<RuntimeClock, Integer> equalityClassMap = new HashMap();
    private HashMap<RuntimeClock, HashSet<ClockConjunction>> clockConjunctions = new HashMap();
    private HashMap<ClockConjunction, HashSet<RuntimeClock>> conjunctImplications = new HashMap();

    public void clear() {
        this.deadClocks.clear();
        this.implications.clear();
        this.equalityClasses.clear();
        this.equalityClassMap.clear();
    }

    public void registerDeadClock(RuntimeClock clock) {
        if (this.deadClocks.add(clock)) {
            int eqClass;
            Set<RuntimeClock> others;
            Set<RuntimeClock> implied = this.implications.get(clock);
            if (implied != null) {
                for (RuntimeClock c : implied) {
                    this.registerDeadClock(c);
                }
            }
            if (this.equalityClassMap.containsKey(clock) && (others = this.equalityClasses.elementAt(eqClass = this.equalityClassMap.get(clock).intValue())) != null) {
                for (RuntimeClock eq : others) {
                    this.registerDeadClock(eq);
                }
            }
            for (ClockConjunction cj : this.findConjunction(clock)) {
                if ((cj.clock1 != clock || !this.deadClocks.contains(cj.clock2)) && (cj.clock2 != clock || !this.deadClocks.contains(cj.clock1))) continue;
                for (RuntimeClock right : this.conjunctImplications.get(cj)) {
                    this.registerDeadClock(right);
                }
            }
        }
    }

    public void registerEquality(RuntimeClock c1, RuntimeClock c2) {
        if (c1 == c2) {
            return;
        }
        Integer class1 = this.equalityClassMap.get(c1);
        Integer class2 = this.equalityClassMap.get(c2);
        if (class1 != null) {
            if (class2 != null) {
                this.mergeClasses(class1, class2);
            } else {
                this.storeInClass(class1, c2);
            }
        } else if (class2 != null) {
            this.storeInClass(class2, c1);
        } else {
            int newClass = this.newClassIndex();
            this.storeInClass(newClass, c1);
            this.storeInClass(newClass, c2);
        }
        if (this.deadClocks.contains(c1)) {
            this.registerDeadClock(c2);
        } else if (this.deadClocks.contains(c2)) {
            this.registerDeadClock(c1);
        }
    }

    public void registerImplication(RuntimeClock c1, RuntimeClock c2) {
        if (c1 == c2) {
            return;
        }
        HashSet<RuntimeClock> implied = (HashSet<RuntimeClock>)this.implications.get(c1);
        if (implied == null) {
            implied = new HashSet<RuntimeClock>();
            this.implications.put(c1, implied);
        }
        if (implied.add(c2) && this.deadClocks.contains(c1)) {
            this.registerDeadClock(c2);
        }
    }

    public List<RuntimeClock> getDeadClocks() {
        return new ArrayList<RuntimeClock>(this.deadClocks);
    }

    private int newClassIndex() {
        int i = 0;
        while (i < this.equalityClasses.size()) {
            if (this.equalityClasses.elementAt(i) == null) {
                this.equalityClasses.setElementAt(new HashSet(), i);
                return i;
            }
            ++i;
        }
        int newIndex = this.equalityClasses.size();
        this.equalityClasses.setSize(newIndex + 1);
        this.equalityClasses.setElementAt(new HashSet(), newIndex);
        return newIndex;
    }

    private boolean storeInClass(Integer classIndex, RuntimeClock clock) {
        this.equalityClassMap.put(clock, classIndex);
        return this.equalityClasses.elementAt(classIndex).add(clock);
    }

    private void mergeClasses(Integer class1, Integer class2) {
        int removedClass;
        int targetClass;
        if (class1.compareTo(class2) == 0) {
            return;
        }
        if (class1.compareTo(class2) < 0) {
            targetClass = class1;
            removedClass = class2;
        } else {
            targetClass = class2;
            removedClass = class1;
        }
        for (RuntimeClock clock : this.equalityClasses.elementAt(removedClass)) {
            this.storeInClass(targetClass, clock);
        }
        this.equalityClasses.elementAt(removedClass).clear();
        this.equalityClasses.set(removedClass, null);
    }

    public void registerConjunctionImplication(RuntimeClock clock1, RuntimeClock clock2, RuntimeClock clock3) {
        ClockConjunction cj = this.findOrCreateConjunction(clock1, clock2);
        HashSet<Object> right = this.conjunctImplications.get(cj);
        if (right == null) {
            right = new HashSet();
            this.conjunctImplications.put(cj, right);
        }
        right.add(clock3);
        if (this.deadClocks.contains(clock1) && this.deadClocks.contains(clock2)) {
            this.registerDeadClock(clock3);
        }
    }

    private List<ClockConjunction> findConjunction(RuntimeClock ck) {
        ArrayList<ClockConjunction> res = new ArrayList<ClockConjunction>();
        Set set = this.clockConjunctions.get(ck);
        if (set != null) {
            res.addAll(set);
        }
        return res;
    }

    private ClockConjunction findOrCreateConjunction(RuntimeClock clock1, RuntimeClock clock2) {
        Set existing = this.clockConjunctions.get(clock1);
        if (existing != null) {
            for (ClockConjunction elt : existing) {
                if (elt.clock2 != clock2) continue;
                return elt;
            }
        }
        ClockConjunction newConjunct = new ClockConjunction(clock1, clock2);
        this.storeConjunct(newConjunct);
        return newConjunct;
    }

    private void storeConjunct(ClockConjunction cj) {
        HashSet<ClockConjunction> existing = this.clockConjunctions.get(cj.clock1);
        if (existing == null) {
            existing = new HashSet();
            this.clockConjunctions.put(cj.clock1, existing);
        }
        existing.add(cj);
        existing = this.clockConjunctions.get(cj.clock2);
        if (existing == null) {
            existing = new HashSet();
            this.clockConjunctions.put(cj.clock2, existing);
        }
        existing.add(cj);
    }

    private class ClockConjunction {
        public RuntimeClock clock1;
        public RuntimeClock clock2;

        public ClockConjunction(RuntimeClock clock1, RuntimeClock clock2) {
            this.clock1 = clock1;
            this.clock2 = clock2;
        }
    }
}

