/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler;

import fr.inria.aoste.timesquare.ccslkernel.compiler.CompilerParameters;
import fr.inria.aoste.timesquare.ccslkernel.compiler.NameProvider;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.ClassDefinition;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.MemberFunction;
import fr.inria.aoste.timesquare.ccslkernel.compiler.helpers.PluginProjectHelper;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.And;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntDivide;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntEqual;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntInf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntMinus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntMultiply;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntPlus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntSup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.Not;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.NumberSeqVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.Or;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqGetHead;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqGetTail;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqIsEmpty;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.UnaryIntMinus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.UnaryIntPlus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.util.ClassicalExpressionSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import org.eclipse.emf.ecore.EObject;

public class ClassicalExpressionCompiler {
    private CompilerParameters parameters;
    private PluginProjectHelper pluginHelper;
    private NameProvider nameProvider;
    private NamedElement context;
    private String functionName;
    private Class<?> returnType;
    private String returnTypeName;

    public ClassicalExpressionCompiler(CompilerParameters params, PluginProjectHelper pluginHelper, NameProvider nameProvider) {
        this.parameters = params;
        this.pluginHelper = pluginHelper;
        this.nameProvider = nameProvider;
    }

    public String generateClassicalExpression(ClassicalExpression expression, NamedElement context, ClassDefinition enclosingClass) {
        this.context = context;
        this.functionName = this.nameProvider.getFunctionName(expression);
        MemberFunction function = new MemberFunction(this.functionName);
        function.addModifier("private");
        this.returnType = this.nameProvider.getJavaClass((NamedElement)expression);
        this.returnTypeName = this.nameProvider.getClassName((NamedElement)expression);
        function.setReturnType(this.returnTypeName);
        enclosingClass.addImportedPackage(this.returnType.getName());
        String varName = this.generateCode(expression, function, enclosingClass);
        function.addStatement("return " + varName);
        enclosingClass.addMemberFunction(function);
        return this.functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    private String generateCode(ClassicalExpression expression, MemberFunction function, ClassDefinition enclosingClass) {
        return (String)new codeGenerator(function, enclosingClass).doSwitch((EObject)expression);
    }

    private class codeGenerator
    extends ClassicalExpressionSwitch<String> {
        private MemberFunction function;
        private ClassDefinition enclosingClass;

        public codeGenerator(MemberFunction function, ClassDefinition enclosingClass) {
            this.function = function;
            this.enclosingClass = enclosingClass;
        }

        private void addPackage(String packageName) {
            if (!packageName.startsWith("java.lang.")) {
                this.enclosingClass.addImportedPackage(packageName);
            }
        }

        public String caseSeqGetHead(SeqGetHead object) {
            String operandVarname = (String)this.doSwitch((EObject)object.getOperand());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            Class<?> type = ClassicalExpressionCompiler.this.nameProvider.getJavaClass((NamedElement)object);
            String typeName = ClassicalExpressionCompiler.this.nameProvider.getClassName((NamedElement)object);
            this.addPackage(type.getName());
            this.function.addStatement(String.valueOf(typeName) + " " + varName + " = " + "(" + typeName + ")" + operandVarname + ".getHead()");
            return varName;
        }

        public String caseSeqGetTail(SeqGetTail object) {
            String operandVarname = (String)this.doSwitch((EObject)object.getOperand());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            Class<?> type = ClassicalExpressionCompiler.this.nameProvider.getJavaClass((NamedElement)object);
            String typeName = ClassicalExpressionCompiler.this.nameProvider.getClassName((NamedElement)object);
            this.addPackage(type.getName());
            this.function.addStatement(String.valueOf(typeName) + " " + varName + " = " + operandVarname + ".getTail()");
            return varName;
        }

        public String caseSeqIsEmpty(SeqIsEmpty object) {
            String operandVarname = (String)this.doSwitch((EObject)object.getOperand());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            Class<?> type = ClassicalExpressionCompiler.this.nameProvider.getJavaClass((NamedElement)object);
            String typeName = ClassicalExpressionCompiler.this.nameProvider.getClassName((NamedElement)object);
            this.addPackage(type.getName());
            this.function.addStatement(String.valueOf(typeName) + " " + varName + " = " + operandVarname + ".isEmpty()");
            return varName;
        }

        public String caseNumberSeqVariableRef(NumberSeqVariableRef object) {
            AbstractEntity refVar = object.getReferencedVar();
            String varName = ClassicalExpressionCompiler.this.nameProvider.getVariableName((NamedElement)refVar);
            return varName;
        }

        public String caseAnd(And object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Boolean " + varName + " = (" + leftVarname + " && " + rightVarname + ")");
            return varName;
        }

        public String caseOr(Or object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Boolean " + varName + " = (" + leftVarname + " || " + rightVarname + ")");
            return varName;
        }

        public String caseNot(Not object) {
            String operandVarname = (String)this.doSwitch((EObject)object.getOperand());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Boolean " + varName + " = ( ! " + operandVarname + ")");
            return varName;
        }

        public String caseBooleanVariableRef(BooleanVariableRef object) {
            return ClassicalExpressionCompiler.this.nameProvider.getVariableName((NamedElement)object.getReferencedVar());
        }

        public String caseBooleanRef(BooleanRef object) {
            return object.getReferencedBool().getValue() != false ? "true" : "false";
        }

        public String caseIntInf(IntInf object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Boolean " + varName + " = " + leftVarname + " < " + rightVarname);
            return varName;
        }

        public String caseIntSup(IntSup object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Boolean " + varName + " = " + leftVarname + " > " + rightVarname);
            return varName;
        }

        public String caseUnaryIntMinus(UnaryIntMinus object) {
            String operandVarname = (String)this.doSwitch((EObject)object.getOperand());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Integer " + varName + " = - (" + operandVarname + ")");
            return varName;
        }

        public String caseUnaryIntPlus(UnaryIntPlus object) {
            String operandVarname = (String)this.doSwitch((EObject)object.getOperand());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Integer " + varName + " = + (" + operandVarname + ")");
            return varName;
        }

        public String caseIntPlus(IntPlus object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Integer " + varName + " = " + leftVarname + " + " + rightVarname);
            return varName;
        }

        public String caseIntMinus(IntMinus object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Integer " + varName + " = " + leftVarname + " - " + rightVarname);
            return varName;
        }

        public String caseIntMultiply(IntMultiply object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Integer " + varName + " = " + leftVarname + " * " + rightVarname);
            return varName;
        }

        public String caseIntDivide(IntDivide object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Integer " + varName + " = " + leftVarname + " / " + rightVarname);
            return varName;
        }

        public String caseIntEqual(IntEqual object) {
            String leftVarname = (String)this.doSwitch((EObject)object.getLeftValue());
            String rightVarname = (String)this.doSwitch((EObject)object.getRightValue());
            String varName = ClassicalExpressionCompiler.this.nameProvider.genSym();
            this.function.addStatement("Boolean " + varName + " = (" + leftVarname + " == " + rightVarname + ")");
            return varName;
        }

        public String caseIntegerVariableRef(IntegerVariableRef object) {
            return ClassicalExpressionCompiler.this.nameProvider.getVariableName((NamedElement)object.getReferencedVar());
        }

        public String caseIntegerRef(IntegerRef object) {
            IntegerElement referencedInt = object.getIntegerElem();
            if (referencedInt.eContainer() == ClassicalExpressionCompiler.this.context) {
                return ClassicalExpressionCompiler.this.nameProvider.getVariableName((NamedElement)referencedInt);
            }
            return object.getIntegerElem().getValue().toString();
        }
    }
}

