/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.context;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.ReplicatedMap;
import org.apache.catalina.util.Enumerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ReplicatedContext
extends StandardContext
implements LifecycleListener,
AbstractReplicatedMap.MapOwner {
    private int mapSendOptions = 2;
    public static Log log = LogFactory.getLog(ReplicatedContext.class);
    protected boolean startComplete = false;
    protected static long DEFAULT_REPL_TIMEOUT = 15000L;

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            this.startComplete = true;
        }
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (Exception ex) {
                throw new LifecycleException("Error initializaing ", (Throwable)ex);
            }
        }
        super.addLifecycleListener((LifecycleListener)this);
        try {
            CatalinaCluster catclust = (CatalinaCluster)this.getCluster();
            if (this.context == null) {
                this.context = new ReplApplContext(this.getBasePath(), this);
            }
            if (catclust != null) {
                ReplicatedMap map = new ReplicatedMap((AbstractReplicatedMap.MapOwner)this, catclust.getChannel(), DEFAULT_REPL_TIMEOUT, this.getName(), this.getClassLoaders());
                map.setChannelSendOptions(this.mapSendOptions);
                ((ReplApplContext)this.context).setAttributeMap((AbstractMap)map);
                if (this.getAltDDName() != null) {
                    this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
                }
            }
            super.start();
        }
        catch (Exception x) {
            log.error((Object)"Unable to start ReplicatedContext", (Throwable)x);
            throw new LifecycleException("Failed to start ReplicatedContext", (Throwable)x);
        }
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        AbstractMap map = ((ReplApplContext)this.context).getAttributeMap();
        if (map != null && map instanceof ReplicatedMap) {
            ((ReplicatedMap)map).breakdown();
        }
        try {
            try {
                this.lifecycle.removeLifecycleListener((LifecycleListener)this);
            }
            catch (Exception x) {
                log.error((Object)"Unable to stop ReplicatedContext", (Throwable)x);
                throw new LifecycleException("Failed to stop ReplicatedContext", (Throwable)x);
            }
            Object var4_2 = null;
            this.startComplete = false;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.startComplete = false;
            super.stop();
            throw throwable;
        }
        super.stop();
    }

    public void setMapSendOptions(int mapSendOptions) {
        this.mapSendOptions = mapSendOptions;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public ClassLoader[] getClassLoaders() {
        Loader loader = null;
        ClassLoader classLoader = null;
        loader = this.getLoader();
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == Thread.currentThread().getContextClassLoader()) {
            return new ClassLoader[]{classLoader};
        }
        return new ClassLoader[]{classLoader, Thread.currentThread().getContextClassLoader()};
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ReplApplContext(this.getBasePath(), this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return ((ReplApplContext)this.context).getFacade();
    }

    public void objectMadePrimay(Object key, Object value) {
    }

    protected static class MultiEnumeration
    implements Enumeration {
        Enumeration[] e = null;

        public MultiEnumeration(Enumeration[] lists) {
            this.e = lists;
        }

        public boolean hasMoreElements() {
            for (int i = 0; i < this.e.length; ++i) {
                if (!this.e[i].hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            for (int i = 0; i < this.e.length; ++i) {
                if (!this.e[i].hasMoreElements()) continue;
                return this.e[i].nextElement();
            }
            return null;
        }
    }

    protected static class ReplApplContext
    extends ApplicationContext {
        protected ConcurrentHashMap tomcatAttributes = new ConcurrentHashMap();

        public ReplApplContext(String basePath, ReplicatedContext context) {
            super(basePath, (StandardContext)context);
        }

        protected ReplicatedContext getParent() {
            return (ReplicatedContext)this.getContext();
        }

        protected ServletContext getFacade() {
            return super.getFacade();
        }

        public AbstractMap getAttributeMap() {
            return (AbstractMap)this.attributes;
        }

        public void setAttributeMap(AbstractMap map) {
            this.attributes = map;
        }

        public void removeAttribute(String name) {
            this.tomcatAttributes.remove(name);
            super.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            if (!this.getParent().startComplete || "org.apache.jasper.runtime.JspApplicationContextImpl".equals(name)) {
                this.tomcatAttributes.put(name, value);
            } else {
                super.setAttribute(name, value);
            }
        }

        public Object getAttribute(String name) {
            if (this.tomcatAttributes.containsKey(name)) {
                return this.tomcatAttributes.get(name);
            }
            return super.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return new MultiEnumeration(new Enumeration[]{super.getAttributeNames(), new Enumerator((Collection)this.tomcatAttributes.keySet(), true)});
        }
    }
}

