/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.configurationadmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import javax.management.openmbean.TabularData;
import org.eclipse.gemini.management.internal.OSGiProperties;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.jmx.service.cm.ConfigurationAdminMBean;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;

public final class ConfigAdminManager
implements ConfigurationAdminMBean {
    private final ConfigurationAdmin admin;
    private final LogService logger;

    public ConfigAdminManager(ConfigurationAdmin admin, LogService logger) {
        this.admin = admin;
        this.logger = logger;
    }

    private void log(int level, String message, Throwable t) {
        if (this.logger != null) {
            this.logger.log(level, message, t);
        }
    }

    @Override
    public String createFactoryConfiguration(String factoryPid) throws IOException {
        if (factoryPid == null) {
            throw new IOException("Factory PID must not be null");
        }
        Configuration c = this.admin.createFactoryConfiguration(factoryPid);
        c.setBundleLocation(null);
        return c.getPid();
    }

    @Override
    public String createFactoryConfigurationForLocation(String factoryPid, String location) throws IOException {
        if (factoryPid == null) {
            throw new IOException("Factory PID must not be null");
        }
        Configuration c = this.admin.createFactoryConfiguration(factoryPid);
        c.setBundleLocation(location);
        return c.getPid();
    }

    @Override
    public void delete(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, null).delete();
    }

    @Override
    public void deleteForLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, location).delete();
    }

    @Override
    public void deleteConfigurations(String filter) throws IOException {
        Configuration[] confs;
        try {
            confs = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            this.log(1, "Invalid filter argument: " + filter, e);
            throw new IOException("Invalid filter: " + (Object)((Object)e));
        }
        if (confs != null) {
            Configuration[] configurationArray = confs;
            int n = confs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration conf = configurationArray[n2];
                conf.delete();
                ++n2;
            }
        }
    }

    @Override
    public String getBundleLocation(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        return this.admin.getConfiguration(pid, null).getBundleLocation();
    }

    @Override
    public String getFactoryPid(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        return this.admin.getConfiguration(pid, null).getFactoryPid();
    }

    @Override
    public String getFactoryPidForLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        return this.admin.getConfiguration(pid, location).getFactoryPid();
    }

    @Override
    public TabularData getProperties(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        Dictionary properties = this.admin.getConfiguration(pid, null).getProperties();
        return properties == null ? null : OSGiProperties.tableFrom(properties);
    }

    @Override
    public TabularData getPropertiesForLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        Dictionary properties = this.admin.getConfiguration(pid, location).getProperties();
        return properties == null ? null : OSGiProperties.tableFrom(properties);
    }

    @Override
    public String[][] getConfigurations(String filter) throws IOException {
        Configuration[] configurations;
        ArrayList<String[]> pids = new ArrayList<String[]>();
        try {
            configurations = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            this.log(1, "Invalid filter argument: " + filter, e);
            throw new IOException("Invalid filter: " + (Object)((Object)e));
        }
        if (configurations != null) {
            Configuration[] configurationArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration config = configurationArray[n2];
                pids.add(new String[]{config.getPid(), config.getBundleLocation()});
                ++n2;
            }
        }
        return (String[][])pids.toArray((T[])new String[pids.size()][]);
    }

    @Override
    public void setBundleLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid).setBundleLocation(location);
    }

    @Override
    public void update(String pid, TabularData table) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, null).update(OSGiProperties.propertiesFrom(table));
    }

    @Override
    public void updateForLocation(String pid, String location, TabularData table) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, location).update(OSGiProperties.propertiesFrom(table));
    }
}

