/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public CharSequence genHeaderConstants(ExpandedActorClass xpac) {
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1 function1 = it -> {
            boolean bl = FsmGenExtensions.isLeaf((Node)it);
            return !bl;
        };
        int n = IteratorExtensions.size((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllStateNodes((Graph)xpac.getGraphContainer().getGraph()), (Functions.Function1)function1));
        int historySize = n + 2;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/* constant for state machine data */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#define ");
        String string = ac.getName().toUpperCase();
        stringConcatenation2.append(string);
        stringConcatenation2.append("_HISTORY_SIZE ");
        stringConcatenation2.append((Object)historySize);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence genDataMembers(ExpandedActorClass xpac) {
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/* state machine variables */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("etInt16 state;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("etInt16 history[");
        String string = ac.getName().toUpperCase();
        stringConcatenation2.append(string);
        stringConcatenation2.append("_HISTORY_SIZE];");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence genInitialization(ExpandedActorClass xpac) {
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("self->state = STATE_TOP;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("int i;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("for (i=0; i<");
        String string = ac.getName().toUpperCase();
        stringConcatenation2.append(string, "\t");
        stringConcatenation2.append("_HISTORY_SIZE; ++i)");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("self->history[i] = NO_STATE;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        String string2 = this.langExt.operationScope(ac.getName(), false);
        stringConcatenation2.append(string2);
        stringConcatenation2.append("executeInitTransition(self);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence genExtra(GraphContainer gc, boolean generateImplementation) {
        StringConcatenation stringConcatenation = null;
        ModelComponent mc = gc.getComponent();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/* state names */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#ifdef ET_MSC_LOGGER_ACTIVATE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("static const char* stateStrings[] = {\"<no state>\",\"<top>\",");
        Object object = gc.getOrderedStates();
        boolean bl = false;
        for (State state : object) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation2.appendImmediate((Object)",", "\t");
            }
            stringConcatenation2.append("\"");
            String string = this._codegenHelpers.getGenStatePathName(state);
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.append("\"");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
        }
        stringConcatenation2.append("};");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        object = this.langExt.accessLevelPrivate();
        stringConcatenation2.append((String)object);
        stringConcatenation2.append("void setState(");
        String string = mc.getComponentName();
        stringConcatenation2.append(string);
        stringConcatenation2.append("* self, ");
        String string2 = this.stateType();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" new_state) {");
        stringConcatenation2.newLineIfNotEmpty();
        Object object2 = gc.eContainer();
        boolean bl2 = ((ExpandedActorClass)object2).isTracingEnabled();
        if (bl2) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#ifdef ET_MSC_TRACER_ACTIVATE");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if(self->state != new_state) {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("ET_MSC_TRACER_SET_STATE(self->constData->objId, new_state);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("self->state = new_state;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_CHANGE_STATE(self->constData->instName, stateStrings[new_state]);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        object2 = this.langExt.accessLevelPrivate();
        stringConcatenation2.append((String)object2);
        String string3 = this.stateType();
        stringConcatenation2.append(string3);
        stringConcatenation2.append(" getState(");
        String string4 = mc.getComponentName();
        stringConcatenation2.append(string4);
        stringConcatenation2.append("* self) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("return self->state;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public String stateType() {
        return "etInt16";
    }

    public String boolType() {
        return "etBool";
    }

    public CharSequence markVariableUsed(String varname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("((void)");
        stringConcatenation.append(varname);
        stringConcatenation.append(");\t/* avoids unused warning */");
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public String unreachableReturn() {
        return "/* return NO_STATE; // required by CDT but detected as unreachable by JDT because of while (true) */";
    }
}

