/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class OptionalActorInterfaceGen
extends GenericActorClassGenerator {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public void doGenerate(Root root) {
        EList eList = root.getOptionalActorClasses();
        for (ActorClass ac : eList) {
            String path = this._roomExtensions.getPath((RoomClass)ac);
            String file = this._javaExtensions.getJavaInterfaceFileName(ac, false);
            this.fileIO.generateFile("generating ActorClass Interface implementation", String.valueOf(path) + file, this.generate(root, ac, false));
            file = this._javaExtensions.getJavaInterfaceFileName(ac, true);
            this.fileIO.generateFile("generating ActorClass Interface implementation", String.valueOf(path) + file, this.generate(root, ac, true));
        }
    }

    public CharSequence generate(Root root, ActorClass ac, boolean replicated) {
        Object object;
        StringConcatenation stringConcatenation = null;
        String string = null;
        string = replicated ? "ReplicatedOptionalActorInterfaceBase" : "ScalarOptionalActorInterfaceBase";
        String baseClass = string;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("package ");
        String string2 = this._roomExtensions.getPackage((RoomClass)ac);
        stringConcatenation2.append(string2);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.append("import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.IEventReceiver;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBroker;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.");
        stringConcatenation2.append(baseClass);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        String string3 = this._javaExtensions.getJavaInterfaceName(ac, replicated);
        stringConcatenation2.append(string3);
        stringConcatenation2.append(" extends ");
        stringConcatenation2.append(baseClass);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- brokers for ports on the interface");
        stringConcatenation2.newLine();
        Object object2 = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            Port ep = (Port)object3.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected InterfaceItemBroker ");
            object = ep.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(" = null;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- interface item IDs");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object2 = this.genInterfaceItemConstantsForOptionalActor(ac);
        stringConcatenation2.append((String)object2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- construction");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        String string4 = this._javaExtensions.getJavaInterfaceName(ac, replicated);
        stringConcatenation2.append(string4, "\t");
        stringConcatenation2.append(" (IEventReceiver parent, String name) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super(parent, name, \"");
        object3 = ac.getName();
        stringConcatenation2.append((String)object3, "\t\t");
        stringConcatenation2.append("\");");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.newLine();
        object = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string5;
            String string6;
            String string7;
            Port ep_1 = (Port)iterator.next();
            boolean bl2 = ep_1.isReplicated();
            if (bl2) {
                stringConcatenation2.append("\t\t");
                string7 = ep_1.getName();
                stringConcatenation2.append(string7, "\t\t");
                stringConcatenation2.append(" = new ReplicatedInterfaceItemBroker(this, \"");
                string6 = ep_1.getName();
                stringConcatenation2.append(string6, "\t\t");
                stringConcatenation2.append("\", ");
                string5 = this.getIfItemId((AbstractInterfaceItem)ep_1);
                stringConcatenation2.append(string5, "\t\t");
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
                continue;
            }
            stringConcatenation2.append("\t\t");
            string7 = ep_1.getName();
            stringConcatenation2.append(string7, "\t\t");
            stringConcatenation2.append(" = new InterfaceItemBroker(this, \"");
            string6 = ep_1.getName();
            stringConcatenation2.append(string6, "\t\t");
            stringConcatenation2.append("\", ");
            string5 = this.getIfItemId((AbstractInterfaceItem)ep_1);
            stringConcatenation2.append(string5, "\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        boolean bl3 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl3) {
            stringConcatenation2.append("\t");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("@Override");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected void logCreation(String actorClass, String name) {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService.getInstance().addMessageActorCreate(this, actorClass, name);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("@Override");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected void logDeletion(String name) {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService.getInstance().addMessageActorDestroy(this, name);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

