/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.fsm.ast.nodes;

import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstTextNode;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class DCAstBracketNode
extends DCAstTextNode {
    private BracketType type;
    private int posClose;
    private boolean closed;

    public DCAstBracketNode(DCAstNode parent, BracketType type, DCAstNode contents, int posOpen, int posClose) {
        super(parent, 2, posOpen, posOpen + 1);
        this.type = type;
        this.posClose = posClose;
        boolean bl = this.closed = posClose >= 0;
        if (contents != null) {
            contents.setParent(this);
        }
    }

    public DCAstBracketNode(DCAstNode parent, BracketType type, DCAstNode contents, int posOpen) {
        this(parent, type, contents, posOpen, -1);
    }

    public String left() {
        String string = null;
        BracketType type = this.type;
        if (type != null) {
            switch (type) {
                case CURLY: {
                    string = "{";
                    break;
                }
                case ROUND: {
                    string = "(";
                    break;
                }
                case SQUARE: {
                    string = "[";
                    break;
                }
            }
        }
        return string;
    }

    public String right() {
        String string = null;
        BracketType type = this.type;
        if (type != null) {
            switch (type) {
                case CURLY: {
                    string = "}";
                    break;
                }
                case ROUND: {
                    string = ")";
                    break;
                }
                case SQUARE: {
                    string = "]";
                    break;
                }
            }
        }
        return string;
    }

    public String toString() {
        String string = null;
        BracketType type = this.type;
        if (type != null) {
            switch (type) {
                case CURLY: {
                    string = "{}";
                    break;
                }
                case ROUND: {
                    string = "()";
                    break;
                }
                case SQUARE: {
                    string = "[]";
                    break;
                }
            }
        }
        return string;
    }

    @Override
    protected void doPrint(String indent) {
        String string = this.toString();
        String string2 = String.valueOf(indent) + "DCAstBracketNode " + string;
        InputOutput.println((Object)string2);
    }

    @Override
    public String getText() {
        return this.toString();
    }

    @Pure
    public BracketType getType() {
        return this.type;
    }

    public void setType(BracketType type) {
        this.type = type;
    }

    @Pure
    public int getPosClose() {
        return this.posClose;
    }

    public void setPosClose(int posClose) {
        this.posClose = posClose;
    }

    @Pure
    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public static enum BracketType {
        ROUND,
        CURLY,
        SQUARE;

    }
}

