/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.BitSet;
import java.util.Iterator;

public class BitSetIterator
implements Iterable<Integer>,
Iterator<Integer> {
    private final BitSet bitSet;
    private int nextIndex;

    public BitSetIterator(BitSet bitSet) {
        this(bitSet, 0);
    }

    public BitSetIterator(BitSet bitSet, int fromIndex) {
        this.bitSet = bitSet;
        this.nextIndex = bitSet.nextSetBit(fromIndex);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex >= 0;
    }

    @Override
    public Integer next() {
        int retValue = this.nextIndex;
        this.nextIndex = this.nextIndex == Integer.MAX_VALUE ? -1 : this.bitSet.nextSetBit(this.nextIndex + 1);
        return retValue;
    }
}

