/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui.commands;

import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.appsview.ui.AppsView;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.CommandUtils;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.TerminateCommandBase;
import org.eclipse.escet.common.app.framework.management.AppManager;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TerminateCommand
extends TerminateCommandBase {
    @Override
    public String getIconUri() {
        return "platform:/plugin/org.eclipse.escet.common.app.framework.appsview.ui/icons/command_remove.png";
    }

    @Override
    public String getItemLabel() {
        return "T&erminate";
    }

    @Override
    public String getTooltip() {
        return "Terminate all selected application";
    }

    @Override
    public String getContributionUri() {
        return "bundleclass://org.eclipse.escet.common.app.framework.appsview.ui/" + this.getClass().getName();
    }

    @Override
    public ItemType getItemType() {
        return ItemType.PUSH;
    }

    @CanExecute
    public boolean isEnabled(MPart part) {
        return this.canTerminate(part);
    }

    private boolean canTerminate(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return false;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return false;
        }
        Set<TreeItem> selectedRoots = CommandUtils.getSelectedRoots(tree);
        for (TreeItem item : selectedRoots) {
            if (!this.canTerminate(view, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        Set<TreeItem> selectedRoots = CommandUtils.getSelectedRoots(tree);
        Set rootsToTerminate = Sets.setc((int)selectedRoots.size());
        for (TreeItem root : selectedRoots) {
            if (!this.canTerminate(view, root)) continue;
            rootsToTerminate.add(root);
        }
        Set appsToTerminate = Sets.setc((int)rootsToTerminate.size());
        Map<Application<?>, TreeItem> treeItems = view.getTreeItems();
        for (Map.Entry<Application<?>, TreeItem> entry : treeItems.entrySet()) {
            if (!rootsToTerminate.contains(entry.getValue())) continue;
            appsToTerminate.add(entry.getKey());
        }
        for (Application app : appsToTerminate) {
            AppManager.terminate((Application)app);
        }
    }
}

