/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.io;

import org.eclipse.escet.chi.runtime.data.io.ChiReadDataFile;
import org.eclipse.escet.chi.runtime.data.io.ChiStdioFile;
import org.eclipse.escet.chi.runtime.data.io.ChiWriteDataFile;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public abstract class ChiFileHandle {
    public final String filename;
    public final String operations;

    public static ChiFileHandle createFile(String path, String operations, String type) {
        path = path == null || path.isEmpty() ? null : Paths.resolve((String)path);
        if (!type.equals("text")) {
            String msg = "Only type \"text\" is supported for file IO.";
            throw new InvalidInputException(msg);
        }
        if (operations.equals("w") || operations.equals("W")) {
            if (path == null) {
                return new ChiStdioFile("w");
            }
            return new ChiWriteDataFile(path);
        }
        if (operations.equals("r") || operations.equals("R")) {
            if (path == null) {
                return new ChiStdioFile("r");
            }
            return new ChiReadDataFile(path);
        }
        String msg = "Unknown file operation \"" + operations + "\". Only \"r\" and \"w\" operations are supported.";
        throw new InvalidInputException(msg);
    }

    public ChiFileHandle(String filename, String operations) {
        this.filename = filename;
        this.operations = operations;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChiFileHandle)) {
            return false;
        }
        ChiFileHandle otherHandle = (ChiFileHandle)other;
        if (this.filename != null) {
            if (otherHandle.filename == null) {
                return false;
            }
            return this.filename.equals(otherHandle.filename);
        }
        if (otherHandle.filename != null) {
            return false;
        }
        return this.operations.equals(otherHandle.operations);
    }

    public int hashCode() {
        if (this.filename == null) {
            return this.operations.hashCode();
        }
        return this.filename.hashCode();
    }

    public abstract int read();

    public void markStream() {
        this.markStream(1);
    }

    public abstract void markStream(int var1);

    public abstract void resetStream();

    public static boolean isWhitespace(int kar) {
        return kar == 32 || kar == 9 || kar == 13 || kar == 10;
    }

    public void skipWhitespace() {
        int kar;
        do {
            this.markStream();
        } while (ChiFileHandle.isWhitespace(kar = this.read()));
        this.resetStream();
    }

    public void expectCharacter(int expect) {
        this.expectCharacter(expect, -1);
    }

    public int expectCharacter(int expect1, int expect2) {
        int ch;
        while ((ch = this.read()) != -1) {
            if (ChiFileHandle.isWhitespace(ch)) continue;
            if (ch != expect1 && ch != expect2) break;
            return ch;
        }
        Object msg = Strings.fmt((String)"Expected '%c'", (Object[])new Object[]{expect1});
        if (expect2 > 0) {
            msg = (String)msg + Strings.fmt((String)" or '%c'", (Object[])new Object[]{expect2});
        }
        msg = (String)msg + ", but found " + (ch == -1 ? "EOF" : Strings.fmt((String)"'%c'", (Object[])new Object[]{ch}));
        throw new InputOutputException((String)msg);
    }

    public abstract void write(String var1);

    public void flush() {
    }

    public abstract boolean isClosed();

    public abstract void close();
}

