/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.java;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.java.JavaParameter;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class JavaMethod {
    protected final String header;
    public CodeBox lines;

    public static JavaMethod makeJavaMethod(String accessors, TypeID retTid, String name, List<VariableDeclaration> arguments, CodeGeneratorContext ctxt) {
        return new JavaMethod(accessors, retTid, name, JavaMethod.makeParameters(arguments, ctxt), ctxt);
    }

    public static JavaMethod makeJavaMethod(String accessors, String name, List<VariableDeclaration> arguments, CodeGeneratorContext ctxt) {
        return new JavaMethod(accessors, null, name, JavaMethod.makeParameters(arguments, ctxt), ctxt);
    }

    public static List<JavaParameter> makeParameters(List<VariableDeclaration> arguments, CodeGeneratorContext ctxt) {
        if (arguments == null) {
            return null;
        }
        List res = Lists.list();
        for (VariableDeclaration vd : arguments) {
            if (!vd.isParameter()) continue;
            TypeID tid = TypeIDCreation.createTypeID(vd.getType(), ctxt);
            res.add(new JavaParameter(tid, "p_" + vd.getName()));
        }
        return res;
    }

    public JavaMethod(String accessors, TypeID retTid, String name, List<JavaParameter> arguments, CodeGeneratorContext ctxt) {
        this(accessors, retTid == null ? null : retTid.getJavaType(), name, JavaParameter.convertParamsToString(arguments), null);
    }

    public JavaMethod(String accessors, String retType, String name, String parameters, String exceptions) {
        Assert.notNull((Object)name);
        if (parameters == null) {
            parameters = "";
        }
        Object header = accessors;
        if (retType != null) {
            header = (String)header + " " + retType;
        }
        header = (String)header + " " + name + "(" + parameters + ")";
        if (exceptions != null) {
            header = (String)header + " throws " + exceptions;
        }
        this.header = header;
        if (accessors.contains("abstract")) {
            this.lines = null;
        } else {
            this.lines = new MemoryCodeBox();
            this.lines.indent();
        }
    }

    public JavaMethod(String header) {
        this.header = header;
        this.lines = new MemoryCodeBox();
        this.lines.indent();
    }

    public Box generateBox() {
        Assert.check((!this.header.contains("\n") ? 1 : 0) != 0);
        if (this.lines == null) {
            return new TextBox(this.header + ";");
        }
        VBox main = new VBox(0);
        main.add(this.header + " {");
        main.add((Box)this.lines);
        main.add("}");
        return main;
    }
}

