/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89.typeinfos;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.EnumTypeInfo;
import org.eclipse.escet.cif.common.CifDocAnnotationUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Strings;

public class C89EnumTypeInfo
extends EnumTypeInfo
implements C89TypeInfo {
    public final boolean genLocalFunctions;
    private final String prefix;

    public C89EnumTypeInfo(boolean genLocalFunctions, String prefix, EnumType enumType) {
        super(enumType);
        this.prefix = prefix;
        this.genLocalFunctions = genLocalFunctions;
    }

    @Override
    public boolean supportRawMemCmp() {
        return true;
    }

    @Override
    public boolean useValues() {
        return true;
    }

    @Override
    public String getTypePrintName(boolean rawString) {
        return "EnumTypePrint";
    }

    protected String getLiteralName(CodeContext ctxt, EnumLiteral eLit) {
        String litName = Strings.fmt((String)"_%s_%s", (Object[])new Object[]{ctxt.getPrefix(), eLit.getName()});
        return litName;
    }

    @Override
    public ExprCode convertEnumLiteral(EnumLiteralExpression expr, Destination dest, CodeContext ctxt) {
        EnumLiteral eLit = expr.getLiteral();
        String litName = this.getLiteralName(ctxt, eLit);
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeLiteral(litName));
        return result;
    }

    @Override
    public String getTargetType() {
        return this.prefix + "Enum";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
        MemoryCodeBox typeCode = ctxt.makeCodeBox();
        MemoryCodeBox funcCode = ctxt.makeCodeBox();
        this.generateC89TypeCode((CodeBox)typeCode, ctxt);
        this.generateC89FuncCode((CodeBox)typeCode, (CodeBox)funcCode, ctxt);
        typeCode.add();
        ctxt.appendReplacement("generated-types", typeCode.toString());
        ctxt.appendReplacement("type-support-code", funcCode.toString());
    }

    protected void generateC89TypeCode(CodeBox typeCode, CodeContext ctxt) {
        String declarationPrefix = this.genLocalFunctions ? "static " : "extern ";
        String enumInternalTypename = "Enum" + ctxt.getPrefix() + "_";
        String enumTypename = ctxt.getPrefix() + "Enum";
        typeCode.add("enum %s {", new Object[]{enumInternalTypename});
        typeCode.indent();
        EList eLits = this.enumType.getEnum().getLiterals();
        int i = 0;
        while (i < eLits.size()) {
            if (i > 0) {
                typeCode.add();
            }
            EnumLiteral lit = (EnumLiteral)eLits.get(i);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)lit);
            String name = lit.getName();
            if (docs.isEmpty()) {
                typeCode.add("/** Literal \"%s\". */", new Object[]{name});
            } else {
                typeCode.add("/**");
                typeCode.add(" * Literal \"%s\".", new Object[]{name});
                for (String doc : docs) {
                    typeCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        typeCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                typeCode.add(" */");
            }
            typeCode.add("%s,", new Object[]{this.getLiteralName(ctxt, lit)});
            ++i;
        }
        typeCode.dedent();
        typeCode.add("};");
        typeCode.add("typedef enum %s %s;", new Object[]{enumInternalTypename, enumTypename});
        typeCode.add();
        typeCode.add("%sconst char *%s[];", new Object[]{declarationPrefix, "enum_names"});
    }

    protected void generateC89FuncCode(CodeBox typeCode, CodeBox funcCode, CodeContext ctxt) {
        String declarationPrefix;
        String definitionPrefix;
        if (this.genLocalFunctions) {
            definitionPrefix = "static ";
            declarationPrefix = "static ";
        } else {
            definitionPrefix = "";
            declarationPrefix = "extern ";
        }
        String enumTypename = ctxt.getPrefix() + "Enum";
        String header = Strings.fmt((String)"int EnumTypePrint(%s value, char *dest, int start, int end)", (Object[])new Object[]{enumTypename});
        typeCode.add(declarationPrefix + header + ";");
        funcCode.add("%s%s {", new Object[]{definitionPrefix, header});
        funcCode.indent();
        funcCode.add("int last = end - 1;");
        funcCode.add("const char *lit_name = %s[value];", new Object[]{"enum_names"});
        funcCode.add("while (start < last && *lit_name) {");
        funcCode.indent();
        funcCode.add("dest[start++] = *lit_name;");
        funcCode.add("lit_name++;");
        funcCode.dedent();
        funcCode.add("}");
        funcCode.add("dest[start] = '\\0';");
        funcCode.add("return start;");
        funcCode.dedent();
        funcCode.add("}");
        funcCode.add();
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "(${left-value}) == (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "(${left-value} != ${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof C89EnumTypeInfo;
    }

    @Override
    public int hashCode() {
        return C89EnumTypeInfo.class.hashCode();
    }
}

