/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.tokens.AName;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CompParamScope
extends SymbolScope<ComponentParameter> {
    private final AName typeRef;
    private ParentScope<?> typeScope;
    public boolean used = false;

    public CompParamScope(ComponentParameter obj, AName typeRef, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(obj, parent, tchecker);
        Assert.check((parent instanceof AutDefScope || parent instanceof GroupDefScope ? 1 : 0) != 0);
        this.typeRef = typeRef;
    }

    public ParentScope<?> getCompDefScope() {
        Assert.notNull(this.typeScope);
        return this.typeScope;
    }

    @Override
    protected boolean isSubScope() {
        return true;
    }

    @Override
    protected boolean isRootScope() {
        return false;
    }

    @Override
    public String getName() {
        return ((ComponentParameter)this.obj).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.obj);
    }

    @Override
    public String getAbsText() {
        return Strings.fmt((String)"component parameter \"%s\"", (Object[])new Object[]{this.getAbsName()});
    }

    public Box toBox() {
        return new TextBox(Strings.fmt((String)"[ compparam scope \"%s\" for: %s ]", (Object[])new Object[]{this.getName(), this.obj}));
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        SymbolTableEntry entry = this.parent.getParent().resolve(this.typeRef.position, this.typeRef.name, this.tchecker, this.parent.getParent());
        if (!(entry instanceof AutDefScope) && !(entry instanceof GroupDefScope)) {
            this.tchecker.addProblem(ErrMsg.COMP_PARAM_INVALID_TYPE, this.typeRef.position, this.getAbsName());
            throw new SemanticException();
        }
        this.typeScope = (ParentScope)entry;
        CifType paramType = this.parent.getParent().resolveAsType(this.typeRef.name, this.typeRef.position, "", this.tchecker);
        ((ComponentParameter)this.obj).setType(paramType);
        this.status = CheckStatus.FULL;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
    }

    @Override
    protected SymbolTableEntry resolve1(TextPosition position, String id, String done, CifTypeChecker tchecker, SymbolScope<?> origScope) {
        this.used = true;
        this.tcheckForUse();
        if (done.isEmpty()) {
            throw new IllegalArgumentException("done");
        }
        if (origScope != null) {
            throw new IllegalArgumentException("origScope");
        }
        return this.typeScope.resolve1(position, id, done, tchecker, origScope);
    }

    @Override
    public void detectCompDefInstCycles(List<ParentScope<?>> cycle) {
    }
}

