/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.stream.Stream;
import org.apache.jena.ontapi.model.HasDisjoint;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntNamedProperty;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public interface OntDataProperty
extends OntRelationalProperty,
OntNamedProperty<OntDataProperty>,
HasDisjoint<OntDataProperty> {
    public OntNegativeAssertion.WithDataProperty addNegativeAssertion(OntIndividual var1, Literal var2);

    public Stream<OntDataProperty> subProperties(boolean var1);

    public Stream<OntDataProperty> superProperties(boolean var1);

    default public Stream<OntNegativeAssertion.WithDataProperty> negativeAssertions() {
        return this.getModel().ontObjects(OntNegativeAssertion.WithDataProperty.class).filter(a -> this.equals(a.getProperty()));
    }

    default public Stream<OntNegativeAssertion.WithDataProperty> negativeAssertions(OntIndividual source) {
        return this.negativeAssertions().filter(a -> a.getSource().equals(source));
    }

    default public Stream<OntDataRange> ranges() {
        return this.objects(RDFS.range, OntDataRange.class);
    }

    default public Stream<OntDataProperty> subProperties() {
        return this.subProperties(false);
    }

    default public Stream<OntDataProperty> superProperties() {
        return this.superProperties(false);
    }

    @Override
    default public Stream<OntDisjoint.DataProperties> disjoints() {
        return this.getModel().ontObjects(OntDisjoint.DataProperties.class).filter(d -> d.members().anyMatch(this::equals));
    }

    default public Stream<OntDataProperty> disjointProperties() {
        return this.objects(OWL2.propertyDisjointWith, OntDataProperty.class);
    }

    default public Stream<OntDataProperty> equivalentProperties() {
        return this.objects(OWL2.equivalentProperty, OntDataProperty.class);
    }

    default public OntStatement addEquivalentPropertyStatement(OntDataProperty other) {
        return this.addStatement(OWL2.equivalentProperty, other);
    }

    default public OntStatement addPropertyDisjointWithStatement(OntDataProperty other) {
        return this.addStatement(OWL2.propertyDisjointWith, other);
    }

    default public OntDataProperty addSuperProperty(OntDataProperty property) {
        this.addSubPropertyOfStatement(property);
        return this;
    }

    default public OntDataProperty addSubProperty(OntDataProperty property) {
        property.addSubPropertyOfStatement(this);
        return this;
    }

    default public OntDataProperty addRange(OntDataRange range) {
        this.addRangeStatement(range);
        return this;
    }

    @Override
    default public OntDataProperty addDomain(OntClass ce) {
        this.addDomainStatement(ce);
        return this;
    }

    default public OntDataProperty addEquivalentProperty(OntDataProperty other) {
        this.addEquivalentPropertyStatement(other);
        return this;
    }

    default public OntDataProperty addDisjointProperty(OntDataProperty other) {
        this.addPropertyDisjointWithStatement(other);
        return this;
    }

    @Override
    default public OntDataProperty removeSuperProperty(Resource property) {
        this.remove(RDFS.subPropertyOf, property);
        return this;
    }

    @Override
    default public OntDataProperty removeSubProperty(Resource property) {
        this.getModel().statements(property, RDFS.subPropertyOf, this).toList().forEach(s -> this.getModel().remove(s.clearAnnotations()));
        return this;
    }

    @Override
    default public OntDataProperty removeDomain(Resource domain) {
        this.remove(RDFS.domain, domain);
        return this;
    }

    @Override
    default public OntDataProperty removeRange(Resource range) {
        this.remove(RDFS.range, range);
        return this;
    }

    @Override
    default public OntDataProperty removeEquivalentProperty(Resource property) {
        this.remove(OWL2.equivalentProperty, property);
        return this;
    }

    @Override
    default public OntDataProperty removeDisjointProperty(Resource property) {
        this.remove(OWL2.propertyDisjointWith, property);
        return this;
    }

    @Override
    default public OntDataProperty setFunctional(boolean functional) {
        if (functional) {
            this.addFunctionalDeclaration();
        } else {
            this.remove(RDF.type, OWL2.FunctionalProperty);
        }
        return this;
    }
}

