/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.Iterator;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.TripleCollectorMark;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class ElementTriplesBlock
extends Element
implements TripleCollectorMark {
    private final BasicPattern pattern;

    public ElementTriplesBlock() {
        this.pattern = new BasicPattern();
    }

    public ElementTriplesBlock(BasicPattern bgp) {
        this.pattern = bgp;
    }

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    @Override
    public void addTriple(Triple t) {
        this.pattern.add(t);
    }

    @Override
    public int mark() {
        return this.pattern.size();
    }

    @Override
    public void addTriple(int index, Triple t) {
        this.pattern.add(index, t);
    }

    @Override
    public void addTriplePath(TriplePath path) {
        throw new ARQException("Triples-only collector");
    }

    @Override
    public void addTriplePath(int index, TriplePath path) {
        throw new ARQException("Triples-only collector");
    }

    public BasicPattern getPattern() {
        return this.pattern;
    }

    public Iterator<Triple> patternElts() {
        return this.pattern.iterator();
    }

    @Override
    public int hashCode() {
        int calcHashCode = 161;
        return calcHashCode ^= this.pattern.hashCode();
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementTriplesBlock)) {
            return false;
        }
        ElementTriplesBlock eg2 = (ElementTriplesBlock)el2;
        return this.pattern.equiv(eg2.pattern, isoMap);
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

