/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmloutput.impl;

import java.io.PrintWriter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfxml.xmloutput.impl.BaseXMLWriter;
import org.apache.jena.rdfxml.xmloutput.impl.Unparser;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.RDFSyntax;

public class RDFXML_Abbrev
extends BaseXMLWriter
implements RDFErrorHandler {
    private Resource[] types = new Resource[]{OWL.Ontology, RDFS.Datatype, RDFS.Class, OWL.Class, OWL.ObjectProperty, RDF.Property, OWL.DatatypeProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty};
    boolean sReification;
    boolean sIdAttr;
    boolean sDamlCollection;
    boolean sParseTypeCollectionPropertyElt;
    boolean sListExpand;
    boolean sParseTypeLiteralPropertyElt;
    boolean sParseTypeResourcePropertyElt;
    boolean sPropertyAttr;
    boolean sResourcePropertyElt;

    public RDFXML_Abbrev() {
        this.unblockAll();
        this.blockRule(RDFSyntax.propertyAttr);
    }

    @Override
    protected void unblockAll() {
        this.sDamlCollection = false;
        this.sReification = false;
        this.sResourcePropertyElt = false;
        this.sParseTypeLiteralPropertyElt = false;
        this.sParseTypeResourcePropertyElt = false;
        this.sParseTypeCollectionPropertyElt = false;
        this.sIdAttr = false;
        this.sPropertyAttr = false;
        this.sListExpand = false;
    }

    @Override
    protected void blockRule(Resource r) {
        if (r.equals(RDFSyntax.sectionReification)) {
            this.sReification = true;
        } else if (r.equals(RDFSyntax.sectionListExpand)) {
            this.sListExpand = true;
        } else if (r.equals(RDFSyntax.parseTypeLiteralPropertyElt)) {
            this.sParseTypeLiteralPropertyElt = true;
        } else if (r.equals(RDFSyntax.parseTypeResourcePropertyElt)) {
            this.sParseTypeResourcePropertyElt = true;
        } else if (r.equals(RDFSyntax.parseTypeCollectionPropertyElt)) {
            this.sParseTypeCollectionPropertyElt = true;
        } else if (r.equals(RDFSyntax.idAttr)) {
            this.sIdAttr = true;
            this.sReification = true;
        } else if (r.equals(RDFSyntax.propertyAttr)) {
            this.sPropertyAttr = true;
        } else {
            logger.warn("Cannot block rule <" + r.getURI() + ">");
        }
    }

    @Override
    Resource[] setTypes(Resource[] propValue) {
        Resource[] rslt = this.types;
        this.types = propValue;
        return rslt;
    }

    @Override
    protected void writeBody(Model model, PrintWriter pw, String base, boolean useXMLBase) {
        Unparser unp = new Unparser(this, base, model, pw);
        unp.setTopLevelTypes(this.types);
        if (useXMLBase) {
            unp.setXMLBase(base);
        }
        unp.write();
    }

    @Override
    public void error(Exception e2) {
        this.errorHandler.error(e2);
    }

    @Override
    public void warning(Exception e2) {
        this.errorHandler.warning(e2);
    }

    @Override
    public void fatalError(Exception e2) {
        this.errorHandler.fatalError(e2);
    }
}

