/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.dsl;

import java.util.Date;
import org.eclipse.emf.emfstore.bowling.BowlingFactory;
import org.eclipse.emf.emfstore.bowling.Game;
import org.eclipse.emf.emfstore.bowling.League;
import org.eclipse.emf.emfstore.bowling.Matchup;
import org.eclipse.emf.emfstore.bowling.Player;
import org.eclipse.emf.emfstore.bowling.Tournament;
import org.eclipse.emf.emfstore.bowling.TournamentType;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.test.common.TestSessionProvider2;
import org.eclipse.emf.emfstore.client.test.common.builders.BOOL;
import org.eclipse.emf.emfstore.client.test.common.builders.UserBuilder;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AncestorVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.DateVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PagedUpdateVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.emf.emfstore.test.model.TestElement;
import org.eclipse.emf.emfstore.test.model.TestmodelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Create {
    private static final String TRUNK = "trunk";

    private Create() {
    }

    public static ESLocalProject project(String projectName) {
        return ESWorkspaceProvider.INSTANCE.getWorkspace().createLocalProject(projectName);
    }

    public static ACOrgUnitId user(UserBuilder<BOOL.TRUE, BOOL.TRUE, BOOL.TRUE> userBuilder) throws ESException {
        try {
            AdminConnectionManager adminConnectionManager = ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager();
            SessionId sessionId = TestSessionProvider2.getInstance().getDefaultUsersession().getSessionId();
            ESServerImpl s = (ESServerImpl)ESServerImpl.class.cast(userBuilder.getServer());
            adminConnectionManager.initConnection((ServerInfo)s.toInternalAPI(), sessionId);
            ACOrgUnitId orgUnitId = adminConnectionManager.createUser(sessionId, userBuilder.getUsername());
            adminConnectionManager.changeUser(sessionId, orgUnitId, userBuilder.getUsername(), userBuilder.getPassword());
            return orgUnitId;
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrimaryVersionSpec primaryVersionSpec(int identifier) {
        return Create.primaryVersionSpec(identifier, TRUNK);
    }

    public static PrimaryVersionSpec primaryVersionSpec(int identifier, String branch) {
        PrimaryVersionSpec primaryVersionSpec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
        primaryVersionSpec.setIdentifier(identifier);
        primaryVersionSpec.setBranch(branch);
        return primaryVersionSpec;
    }

    public static BranchVersionSpec branchVersionSpec() {
        return Create.branchVersionSpec(TRUNK);
    }

    public static BranchVersionSpec branchVersionSpec(String branch) {
        BranchVersionSpec branchVersionSpec = VersioningFactory.eINSTANCE.createBranchVersionSpec();
        branchVersionSpec.setBranch(branch);
        return branchVersionSpec;
    }

    public static ProjectId projectId() {
        return ModelFactory.eINSTANCE.createProjectId();
    }

    public static LogMessage logMessage() {
        return VersioningFactory.eINSTANCE.createLogMessage();
    }

    public static ChangePackage changePackage() {
        return VersioningFactory.eINSTANCE.createChangePackage();
    }

    public static AttributeOperation attributeOp() {
        return OperationsFactory.eINSTANCE.createAttributeOperation();
    }

    public static TestElement testElement() {
        return TestmodelFactory.eINSTANCE.createTestElement();
    }

    public static Player player() {
        return BowlingFactory.eINSTANCE.createPlayer();
    }

    public static Player player(String playerName) {
        Player player = BowlingFactory.eINSTANCE.createPlayer();
        player.setName(playerName);
        return player;
    }

    public static TestElement testElement(String name) {
        TestElement testElement = TestmodelFactory.eINSTANCE.createTestElement();
        testElement.setName(name);
        return testElement;
    }

    public static PagedUpdateVersionSpec pagedUpdateVersionSpec(ESPrimaryVersionSpec baseVersion, int maxChanges) {
        PagedUpdateVersionSpec pagedUpdateVersionSpec = VersioningFactory.eINSTANCE.createPagedUpdateVersionSpec();
        pagedUpdateVersionSpec.setBaseVersionSpec(Create.primaryVersionSpec(baseVersion.getIdentifier(), TRUNK));
        pagedUpdateVersionSpec.setBranch(TRUNK);
        return pagedUpdateVersionSpec;
    }

    public static Usersession session(ServerInfo server, String username, String password) {
        Usersession usersession = org.eclipse.emf.emfstore.internal.client.model.ModelFactory.eINSTANCE.createUsersession();
        usersession.setServerInfo(server);
        usersession.setUsername(username);
        usersession.setPassword(password);
        return usersession;
    }

    public static TagVersionSpec tagVersionSpec(String branchName, String tagName) {
        TagVersionSpec tagVersionSpec = VersioningFactory.eINSTANCE.createTagVersionSpec();
        tagVersionSpec.setBranch(branchName);
        tagVersionSpec.setName(tagName);
        return tagVersionSpec;
    }

    public static AncestorVersionSpec ancestorVersionSpec(PrimaryVersionSpec source, PrimaryVersionSpec target) {
        AncestorVersionSpec ancestorVersionSpec = VersioningFactory.eINSTANCE.createAncestorVersionSpec();
        ancestorVersionSpec.setSource(source);
        ancestorVersionSpec.setTarget(target);
        return ancestorVersionSpec;
    }

    public static DateVersionSpec dateVersionSpec(Date date) {
        DateVersionSpec dateVersionSpec = VersioningFactory.eINSTANCE.createDateVersionSpec();
        dateVersionSpec.setDate(date);
        return dateVersionSpec;
    }

    public static League league(String name) {
        League league = BowlingFactory.eINSTANCE.createLeague();
        league.setName(name);
        return league;
    }

    public static Game game(Player player) {
        Game game = BowlingFactory.eINSTANCE.createGame();
        game.setPlayer(player);
        return game;
    }

    public static Tournament tournament(boolean professional) {
        Tournament tournament = BowlingFactory.eINSTANCE.createTournament();
        if (professional) {
            tournament.setType(TournamentType.PRO);
        } else {
            tournament.setType(TournamentType.AMATEUR);
        }
        return tournament;
    }

    public static Matchup matchup(Game firstGame, Game secondGame) {
        Matchup matchup = BowlingFactory.eINSTANCE.createMatchup();
        if (firstGame != null) {
            matchup.getGames().add((Object)firstGame);
        }
        if (secondGame != null) {
            matchup.getGames().add((Object)firstGame);
        }
        return matchup;
    }
}

