/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport.ImportItemWrapper;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport.ImportSource;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.util.EMFStorePreferenceHelper;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CSVImportSource
extends ImportSource {
    private static final String CSV_IMPORT_SOURCE_PATH = "org.eclipse.emf.emfstore.client.ui.CSVImportSourcePath";
    private final Map<String, ImportItemWrapper> groupMap = new LinkedHashMap<String, ImportItemWrapper>();
    private ArrayList<ImportItemWrapper> groups;
    private ArrayList<ImportItemWrapper> users;
    private String absFileName;

    public Object[] getChildren(Object ob) {
        ImportItemWrapper importWrapper = (ImportItemWrapper)ob;
        if (importWrapper != null && importWrapper.getChildOrgUnits() != null) {
            return importWrapper.getChildOrgUnits().toArray();
        }
        return null;
    }

    public Object[] getElements(Object ob) {
        return this.groups.toArray();
    }

    public String getLabel() {
        return Messages.CSVImportSource_ImportFromCSV;
    }

    public boolean init(Shell shell) {
        this.groups = new ArrayList();
        this.users = new ArrayList();
        FileDialog dialog = this.createFileDialog();
        if (dialog.open() == null) {
            return false;
        }
        String fileName = dialog.getFileName();
        String filterPath = dialog.getFilterPath();
        if (fileName == null) {
            return false;
        }
        this.absFileName = String.valueOf(filterPath) + File.separatorChar + fileName;
        File file = new File(this.absFileName);
        EMFStorePreferenceHelper.setPreference(CSV_IMPORT_SOURCE_PATH, filterPath);
        try {
            return this.readFile(file);
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            return false;
        }
        catch (IOException e) {
            this.handleError(e);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.handleError(e);
            return false;
        }
    }

    private boolean readFile(File file) throws IOException {
        InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
        BufferedReader bufferedReader = new BufferedReader(isr);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                ArrayList<ImportItemWrapper> childOrgUnits;
                String[] title = line.split(",");
                String userName = title[0];
                String groupName = title[1];
                ImportItemWrapper importWrapper = null;
                if (this.groupMap.get(groupName) == null) {
                    ACGroup group = AccesscontrolFactory.eINSTANCE.createACGroup();
                    importWrapper = new ImportItemWrapper(null, (ACOrgUnit)group);
                    group.setName(groupName);
                    this.groups.add(importWrapper);
                    this.groupMap.put(groupName, importWrapper);
                    childOrgUnits = new ArrayList();
                } else {
                    importWrapper = this.groupMap.get(groupName);
                    childOrgUnits = importWrapper.getChildOrgUnits();
                }
                ACUser user = AccesscontrolFactory.eINSTANCE.createACUser();
                user.setName(userName);
                ImportItemWrapper userImportWrapper = new ImportItemWrapper(null, (ACOrgUnit)user, importWrapper);
                this.users.add(userImportWrapper);
                childOrgUnits.add(userImportWrapper);
                importWrapper.setChildOrgUnits(childOrgUnits);
            }
        }
        finally {
            try {
                bufferedReader.close();
                isr.close();
            }
            catch (IOException e) {
                WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
                EMFStoreMessageDialog.showExceptionDialog(e);
                return false;
            }
        }
        return true;
    }

    private FileDialog createFileDialog() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setText(Messages.CSVImportSource_ChooseFile);
        String initialPath = EMFStorePreferenceHelper.getPreference(CSV_IMPORT_SOURCE_PATH, System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        return dialog;
    }

    private void handleError(Exception e) {
        WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
        EMFStoreMessageDialog.showExceptionDialog(e);
    }

    public String getMessage() {
        return String.valueOf(Messages.CSVImportSource_Importing) + this.absFileName;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }
}

