/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.riscv.ui;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.Page_BuildSettings;
import org.eclipse.cdt.ui.newui.ICPropertyProvider2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Activator;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Messages;
import org.eclipse.embedcdt.managedbuild.cross.core.GnuMcuMakefileGenerator;
import org.eclipse.embedcdt.managedbuild.cross.core.Utils;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.Option;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.ToolchainDefinition;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TabToolchains
extends AbstractCBuildPropertyTab {
    private IConfiguration fConfig;
    private IConfiguration fLastUpdatedConfig = null;
    private Combo fToolchainCombo;
    private int fSelectedToolchainIndex;
    private String fSelectedToolchainName;
    private Combo fArchitectureCombo;
    private Text fPrefixText;
    private Text fSuffixText;
    private Text fCommandCText;
    private Text fCommandCppText;
    private Text fCommandArText;
    private Text fCommandObjcopyText;
    private Text fCommandObjdumpText;
    private Text fCommandSizeText;
    private Text fCommandMakeText;
    private Text fCommandRmText;
    private Text fToolchainPathLabel;
    private Text fBuildToolsPathLabel;
    private Button fFlashButton;
    private Button fListingButton;
    private Button fSizeButton;
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    private static int WIDTH_HINT = 120;
    public static final String TYPE_PREFIX = "ilg.gnumcueclipse.managedbuild.cross.riscv.target.";

    protected IProject getProject() {
        assert (this.fConfig != null);
        return (IProject)this.fConfig.getManagedProject().getOwner();
    }

    protected String getSelectedToolchainName() {
        int index;
        assert (this.fToolchainCombo != null);
        try {
            String sSelectedCombo = this.fToolchainCombo.getText();
            index = ToolchainDefinition.findToolchainByFullName((String)sSelectedCombo);
        }
        catch (NullPointerException nullPointerException) {
            index = 0;
        }
        ToolchainDefinition td = ToolchainDefinition.getToolchain((int)index);
        return td.getName();
    }

    public void createControls(final Composite parent) {
        Label label;
        WIDTH_HINT = 200;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.TabToolchains.createControls()");
        }
        if (!this.page.isForProject()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("riscv.TabToolchains.createControls() not this project");
            }
            return;
        }
        super.createControls(parent);
        this.fConfig = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.TabToolchains.createControls() fConfig=" + this.fConfig);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.usercomp.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        this.usercomp.setLayoutData((Object)layoutData);
        Label toolchainLbl = new Label(this.usercomp, 0);
        toolchainLbl.setLayoutData((Object)new GridData(1));
        toolchainLbl.setText(Messages.ToolChainSettingsTab_name);
        this.fToolchainCombo = new Combo(this.usercomp, 4);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.fToolchainCombo.setLayoutData((Object)layoutData);
        this.fToolchainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabToolchains.this.updateInterfaceAfterToolchainChange();
            }
        });
        Label architectureLbl = new Label(this.usercomp, 0);
        architectureLbl.setLayoutData((Object)new GridData(1));
        architectureLbl.setText(Messages.ToolChainSettingsTab_architecture);
        this.fArchitectureCombo = new Combo(this.usercomp, 4);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fArchitectureCombo.setLayoutData((Object)layoutData);
        Label prefixLabel = new Label(this.usercomp, 0);
        prefixLabel.setText(Messages.ToolChainSettingsTab_prefix);
        this.fPrefixText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fPrefixText.setLayoutData((Object)layoutData);
        Label suffixLabel = new Label(this.usercomp, 0);
        suffixLabel.setText(Messages.ToolChainSettingsTab_suffix);
        this.fSuffixText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fSuffixText.setLayoutData((Object)layoutData);
        Label commandCLabel = new Label(this.usercomp, 0);
        commandCLabel.setText(Messages.ToolChainSettingsTab_cCmd);
        this.fCommandCText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fCommandCText.setLayoutData((Object)layoutData);
        Label commandCppLabel = new Label(this.usercomp, 0);
        commandCppLabel.setText(Messages.ToolChainSettingsTab_cppCmd);
        this.fCommandCppText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fCommandCppText.setLayoutData((Object)layoutData);
        if (this.isManaged()) {
            Label commandArLabel = new Label(this.usercomp, 0);
            commandArLabel.setText(Messages.ToolChainSettingsTab_arCmd);
            this.fCommandArText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandArText.setLayoutData((Object)layoutData);
            Label commandObjcopyLabel = new Label(this.usercomp, 0);
            commandObjcopyLabel.setText(Messages.ToolChainSettingsTab_objcopyCmd);
            this.fCommandObjcopyText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandObjcopyText.setLayoutData((Object)layoutData);
            Label commandObjdumpLabel = new Label(this.usercomp, 0);
            commandObjdumpLabel.setText(Messages.ToolChainSettingsTab_objdumpCmd);
            this.fCommandObjdumpText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandObjdumpText.setLayoutData((Object)layoutData);
            Label commandSizeLabel = new Label(this.usercomp, 0);
            commandSizeLabel.setText(Messages.ToolChainSettingsTab_sizeCmd);
            this.fCommandSizeText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandSizeText.setLayoutData((Object)layoutData);
            Label commandMakeLabel = new Label(this.usercomp, 0);
            commandMakeLabel.setText(Messages.ToolChainSettingsTab_makeCmd);
            this.fCommandMakeText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandMakeText.setLayoutData((Object)layoutData);
            Label commandRmLabel = new Label(this.usercomp, 0);
            commandRmLabel.setText(Messages.ToolChainSettingsTab_rmCmd);
            this.fCommandRmText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandRmText.setLayoutData((Object)layoutData);
            this.fCommandRmText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                }
            });
        } else {
            label = new Label(this.usercomp, 0);
            label.setText("");
            Label link = new Label(this.usercomp, 0);
            link.setText(Messages.ToolChainSettingsTab_warning_link);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            link.setLayoutData((Object)layoutData);
        }
        Label empty = new Label(this.usercomp, 0);
        empty.setText("");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        empty.setLayoutData((Object)layoutData);
        label = new Label(this.usercomp, 0);
        label.setText(Messages.ToolChainSettingsTab_path_label);
        this.fToolchainPathLabel = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0, true, false);
        layoutData.horizontalSpan = 2;
        this.fToolchainPathLabel.setLayoutData((Object)layoutData);
        this.fToolchainPathLabel.setEnabled(true);
        this.fToolchainPathLabel.setEditable(false);
        Label label2 = new Label(this.usercomp, 0);
        label2.setText("");
        Link toolchainLink = new Link(this.usercomp, 0);
        toolchainLink.setText(Messages.ToolChainSettingsTab_path_link);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        toolchainLink.setLayoutData((Object)layoutData);
        label2 = new Label(this.usercomp, 0);
        label2.setText(Messages.ToolsSettingsTab_path_label);
        this.fBuildToolsPathLabel = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0, true, false);
        layoutData.horizontalSpan = 2;
        this.fBuildToolsPathLabel.setLayoutData((Object)layoutData);
        this.fBuildToolsPathLabel.setEnabled(true);
        this.fBuildToolsPathLabel.setEditable(false);
        Label label3 = new Label(this.usercomp, 0);
        label3.setText("");
        Link buildToolsLink = new Link(this.usercomp, 0);
        buildToolsLink.setText(Messages.ToolsSettingsTab_path_link);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        buildToolsLink.setLayoutData((Object)layoutData);
        Label empty2 = new Label(this.usercomp, 0);
        empty2.setText("");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        empty2.setLayoutData((Object)layoutData);
        if (this.isManaged()) {
            this.fFlashButton = new Button(this.usercomp, 32);
            this.fFlashButton.setText(Messages.ToolChainSettingsTab_flash);
            layoutData = new GridData(16384, 128, false, false, 3, 1);
            this.fFlashButton.setLayoutData((Object)layoutData);
            this.fListingButton = new Button(this.usercomp, 32);
            this.fListingButton.setText(Messages.ToolChainSettingsTab_listing);
            layoutData = new GridData(16384, 128, false, false, 3, 1);
            this.fListingButton.setLayoutData((Object)layoutData);
            this.fSizeButton = new Button(this.usercomp, 32);
            this.fSizeButton.setText(Messages.ToolChainSettingsTab_size);
            layoutData = new GridData(16384, 128, false, false, 3, 1);
            this.fSizeButton.setLayoutData((Object)layoutData);
        }
        toolchainLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.globalToolchainsPaths", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.workspaceToolchainsPaths", null, null).open();
                } else if ("project".equals(text)) {
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)TabToolchains.this.getProject(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.properties.toolchainsPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabToolchains.this.updateToolchainPath(TabToolchains.this.getSelectedToolchainName());
                }
            }
        });
        buildToolsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.ui.preferencePage.globalToolsPaths", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.ui.preferencePage.workspaceToolsPaths", null, null).open();
                } else if ("project".equals(text)) {
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)TabToolchains.this.getProject(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.ui.properties.toolsPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabToolchains.this.updateBuildToolsPath();
                }
            }
        });
        this.updateControlsForConfig(this.fConfig);
    }

    private void updateInterfaceAfterToolchainChange() {
        int index;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.TabToolchains.updateInterfaceAfterToolchainChange()");
        }
        try {
            String sSelectedCombo = this.fToolchainCombo.getText();
            index = ToolchainDefinition.findToolchainByFullName((String)sSelectedCombo);
        }
        catch (NullPointerException nullPointerException) {
            index = 0;
        }
        ToolchainDefinition td = ToolchainDefinition.getToolchain((int)index);
        index = 0;
        this.fArchitectureCombo.setText(ToolchainDefinition.getArchitecture((int)index));
        this.fPrefixText.setText(td.getPrefix());
        this.fSuffixText.setText(td.getSuffix());
        this.fCommandCText.setText(td.getCmdC());
        this.fCommandCppText.setText(td.getCmdCpp());
        if (this.isManaged()) {
            this.fCommandArText.setText(td.getCmdAr());
            this.fCommandObjcopyText.setText(td.getCmdObjcopy());
            this.fCommandObjdumpText.setText(td.getCmdObjdump());
            this.fCommandSizeText.setText(td.getCmdSize());
            this.fCommandMakeText.setText(td.getCmdMake());
            String oldCommandRm = this.fCommandRmText.getText();
            String newCommandRm = td.getCmdRm();
            if (oldCommandRm == null || !oldCommandRm.equals(newCommandRm)) {
                this.fCommandRmText.setText(newCommandRm);
            }
        }
        this.updateToolchainPath(td.getName());
    }

    protected void updateToolchainPath(String toolchainName) {
        assert (this.fConfig != null);
        IProject project = (IProject)this.fConfig.getManagedProject().getOwner();
        String toolchainPath = this.fPersistentPreferences.getToolchainPath(toolchainName, project);
        this.fToolchainPathLabel.setText(toolchainPath);
    }

    protected void updateBuildToolsPath() {
        assert (this.fConfig != null);
        IProject project = (IProject)this.fConfig.getManagedProject().getOwner();
        String toolchainPath = this.fPersistentPreferences.getBuildToolsPath(project);
        this.fBuildToolsPathLabel.setText(toolchainPath);
    }

    public void updateData(ICResourceDescription cfgd) {
        boolean isStaticLibrary;
        boolean isExecutable;
        IBuildPropertyValue propertyValue;
        if (cfgd == null) {
            return;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.TabToolchains.updateData() " + this.getCfg().getName());
        }
        if ((propertyValue = this.fConfig.getBuildArtefactType()) != null) {
            String artefactId = propertyValue.getId();
            isExecutable = Utils.BUILD_ARTEFACT_TYPE_EXE.equals(artefactId) || artefactId.endsWith(".exe");
            isStaticLibrary = Utils.BUILD_ARTEFACT_TYPE_STATICLIB.equals(artefactId) || artefactId.endsWith("Lib");
        } else {
            isExecutable = true;
            isStaticLibrary = false;
        }
        IConfiguration config = TabToolchains.getCfg((ICConfigurationDescription)cfgd.getConfiguration());
        if (config instanceof MultiConfiguration) {
            MultiConfiguration multi = (MultiConfiguration)config;
            config = (IConfiguration)multi.getItems()[0];
        }
        this.updateControlsForConfig(config);
        if (this.isManaged()) {
            this.fCommandArText.setEnabled(isStaticLibrary);
            this.fCommandObjcopyText.setEnabled(isExecutable);
            this.fCommandObjdumpText.setEnabled(isExecutable);
            this.fCommandSizeText.setEnabled(isExecutable);
            this.fFlashButton.setEnabled(isExecutable);
            this.fListingButton.setEnabled(isExecutable);
            this.fSizeButton.setEnabled(isExecutable);
        }
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.TabToolchains.performApply() " + src.getName());
        }
        IConfiguration config1 = TabToolchains.getCfg((ICConfigurationDescription)src.getConfiguration());
        IConfiguration config2 = TabToolchains.getCfg((ICConfigurationDescription)dst.getConfiguration());
        this.updateOptions(config1);
        this.updateOptions(config2);
    }

    protected void performOK() {
        IConfiguration config = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.performOK() " + config);
        }
        if (this.fLastUpdatedConfig != null && this.fLastUpdatedConfig.equals(config)) {
            this.updateOptions(config);
        } else if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.performOK() skipped " + this.fConfig);
        }
    }

    private void updateControlsForConfig(IConfiguration config) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.updateControlsForConfig() " + config.getName());
        }
        if (!this.isThisPlugin()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("not this plugin");
            }
            return;
        }
        String[] toolchains = new String[ToolchainDefinition.getSize()];
        int i = 0;
        while (i < ToolchainDefinition.getSize()) {
            toolchains[i] = ToolchainDefinition.getToolchain((int)i).getFullName();
            ++i;
        }
        this.fToolchainCombo.setItems(toolchains);
        this.fSelectedToolchainName = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name");
        if (this.fSelectedToolchainName != null && this.fSelectedToolchainName.length() > 0) {
            try {
                this.fSelectedToolchainIndex = ToolchainDefinition.findToolchainByName((String)this.fSelectedToolchainName);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.fSelectedToolchainIndex = ToolchainDefinition.getDefault();
            }
        } else {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("riscv.Toolchains.updateControlsForConfig() no toolchain selected");
            }
            this.fSelectedToolchainName = this.fPersistentPreferences.getToolchainName();
            this.fSelectedToolchainIndex = ToolchainDefinition.findToolchainByName((String)this.fSelectedToolchainName);
            try {
                TabToolchains.setOptionsForToolchain(config, this.fSelectedToolchainIndex);
            }
            catch (BuildException e1) {
                Activator.log((Throwable)e1);
            }
        }
        String toolchainSel = toolchains[this.fSelectedToolchainIndex];
        this.fToolchainCombo.setText(toolchainSel);
        ToolchainDefinition toolchainDefinition = ToolchainDefinition.getToolchain((int)this.fSelectedToolchainIndex);
        this.fArchitectureCombo.setItems(ToolchainDefinition.getArchitectures());
        int index = 0;
        this.fArchitectureCombo.setText(ToolchainDefinition.getArchitecture((int)index));
        String prefix = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.prefix");
        if (prefix != null) {
            this.fPrefixText.setText(prefix);
        } else {
            this.fPrefixText.setText(toolchainDefinition.getPrefix());
        }
        String suffix = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.suffix");
        if (suffix != null) {
            this.fSuffixText.setText(suffix);
        } else {
            this.fSuffixText.setText(toolchainDefinition.getSuffix());
        }
        String commandC = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.c");
        if (commandC != null) {
            this.fCommandCText.setText(commandC);
        } else {
            this.fCommandCText.setText(toolchainDefinition.getCmdC());
        }
        String commandCpp = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.cpp");
        if (commandCpp != null) {
            this.fCommandCppText.setText(commandCpp);
        } else {
            this.fCommandCppText.setText(toolchainDefinition.getCmdCpp());
        }
        if (this.isManaged()) {
            String commandAr = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.ar");
            if (commandAr != null) {
                this.fCommandArText.setText(commandAr);
            } else {
                this.fCommandArText.setText(toolchainDefinition.getCmdAr());
            }
            String commandObjcopy = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objcopy");
            if (commandObjcopy != null) {
                this.fCommandObjcopyText.setText(commandObjcopy);
            } else {
                this.fCommandObjcopyText.setText(toolchainDefinition.getCmdObjcopy());
            }
            String commandObjdump = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objdump");
            if (commandObjdump != null) {
                this.fCommandObjdumpText.setText(commandObjdump);
            } else {
                this.fCommandObjdumpText.setText(toolchainDefinition.getCmdObjdump());
            }
            String commandSize = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.size");
            if (commandSize != null) {
                this.fCommandSizeText.setText(commandSize);
            } else {
                this.fCommandSizeText.setText(toolchainDefinition.getCmdSize());
            }
            String commandMake = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.make");
            if (commandMake != null) {
                this.fCommandMakeText.setText(commandMake);
            } else {
                this.fCommandMakeText.setText(toolchainDefinition.getCmdMake());
            }
            String commandRm = Option.getOptionStringValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.rm");
            if (commandRm != null) {
                this.fCommandRmText.setText(commandRm);
            } else {
                this.fCommandRmText.setText(toolchainDefinition.getCmdRm());
            }
            Boolean isCreateFlash = Option.getOptionBooleanValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createflash");
            if (isCreateFlash != null) {
                this.fFlashButton.setSelection(isCreateFlash.booleanValue());
            } else {
                this.fFlashButton.setSelection(true);
            }
            Boolean isCreateListing = Option.getOptionBooleanValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createlisting");
            if (isCreateListing != null) {
                this.fListingButton.setSelection(isCreateListing.booleanValue());
            } else {
                this.fListingButton.setSelection(false);
            }
            Boolean isPrintSize = Option.getOptionBooleanValue((IConfiguration)config, (String)"ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.printsize");
            if (isPrintSize != null) {
                this.fSizeButton.setSelection(isPrintSize.booleanValue());
            } else {
                this.fSizeButton.setSelection(true);
            }
        }
        this.fConfig = config;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.updateControlsForConfig() fConfig=" + this.fConfig);
        }
        this.fLastUpdatedConfig = config;
        this.updateToolchainPath(toolchainDefinition.getName());
        this.updateBuildToolsPath();
    }

    private void updateOptions(IConfiguration config) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.updateOptions() " + config.getName());
        }
        if (config instanceof MultiConfiguration) {
            MultiConfiguration multi = (MultiConfiguration)config;
            Object[] objectArray = multi.getItems();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IConfiguration cfg = (IConfiguration)obj;
                this.updateOptions(cfg);
                ++n2;
            }
            return;
        }
        IToolChain toolchain = config.getToolChain();
        try {
            String sSelectedCombo = this.fToolchainCombo.getText();
            int index = ToolchainDefinition.findToolchainByFullName((String)sSelectedCombo);
            ToolchainDefinition td = ToolchainDefinition.getToolchain((int)index);
            IOption option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name");
            config.setOption((IHoldsOptions)toolchain, option, td.getName());
            option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.id");
            config.setOption((IHoldsOptions)toolchain, option, String.valueOf(td.getHash()));
            option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.prefix");
            config.setOption((IHoldsOptions)toolchain, option, this.fPrefixText.getText().trim());
            option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.suffix");
            config.setOption((IHoldsOptions)toolchain, option, this.fSuffixText.getText().trim());
            option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.c");
            config.setOption((IHoldsOptions)toolchain, option, this.fCommandCText.getText().trim());
            option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.cpp");
            config.setOption((IHoldsOptions)toolchain, option, this.fCommandCppText.getText().trim());
            if (this.isManaged()) {
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.ar");
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandArText.getText().trim());
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objcopy");
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandObjcopyText.getText().trim());
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objdump");
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandObjdumpText.getText().trim());
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.size");
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandSizeText.getText().trim());
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.make");
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandMakeText.getText().trim());
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.rm");
                String oldValue = option.getStringValue();
                String newValue = this.fCommandRmText.getText().trim();
                if (newValue != null && !newValue.equals(oldValue)) {
                    config.setOption((IHoldsOptions)toolchain, option, newValue);
                    this.propagateCommandRmUpdate(config);
                }
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createflash");
                config.setOption((IHoldsOptions)toolchain, option, this.fFlashButton.getSelection());
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createlisting");
                config.setOption((IHoldsOptions)toolchain, option, this.fListingButton.getSelection());
                option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.printsize");
                config.setOption((IHoldsOptions)toolchain, option, this.fSizeButton.getSelection());
            }
        }
        catch (NullPointerException e) {
            Activator.log((Throwable)e);
        }
        catch (BuildException e) {
            Activator.log((Throwable)e);
        }
    }

    public static void setOptionsForToolchain(IConfiguration config, int toolchainIndex) throws BuildException {
        IToolChain toolchain = config.getToolChain();
        ToolchainDefinition td = ToolchainDefinition.getToolchain((int)toolchainIndex);
        IOption option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name");
        config.setOption((IHoldsOptions)toolchain, option, td.getName());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.prefix");
        config.setOption((IHoldsOptions)toolchain, option, td.getPrefix());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.suffix");
        config.setOption((IHoldsOptions)toolchain, option, td.getSuffix());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.c");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdC());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.cpp");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdCpp());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.ar");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdAr());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objcopy");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdObjcopy());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objdump");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdObjdump());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.size");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdSize());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.make");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdMake());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.rm");
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdRm());
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createflash");
        config.setOption((IHoldsOptions)toolchain, option, true);
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createlisting");
        config.setOption((IHoldsOptions)toolchain, option, false);
        option = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.printsize");
        config.setOption((IHoldsOptions)toolchain, option, true);
    }

    private void propagateCommandRmUpdate(IConfiguration config) {
        IPath makefilePath;
        IProject project;
        IResource makefileResource;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.propagateCommandRmUpdate(" + config.getName() + ")");
        }
        if ((makefileResource = (project = (IProject)config.getOwner()).findMember((makefilePath = project.getFullPath().append(config.getName()).append("makefile")).removeFirstSegments(1))) != null && makefileResource.exists()) {
            try {
                makefileResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                GnuMcuMakefileGenerator makefileGenerator = new GnuMcuMakefileGenerator();
                makefileGenerator.initialize(0, config, config.getBuilder(), (IProgressMonitor)new NullProgressMonitor());
                makefileGenerator.regenerateMakefiles();
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
        }
    }

    protected void performDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.performDefaults()");
        }
        this.updateInterfaceAfterToolchainChange();
        if (this.isManaged()) {
            this.fFlashButton.setSelection(true);
            this.fListingButton.setSelection(false);
            this.fSizeButton.setSelection(true);
        }
    }

    public boolean canBeVisible() {
        if (!this.isThisPlugin()) {
            return false;
        }
        return this.page.isForProject();
    }

    public boolean canSupportMultiCfg() {
        return true;
    }

    protected void updateButtons() {
    }

    private boolean isThisPlugin() {
        IToolChain toolchain;
        String sToolchainId;
        this.fConfig = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.Toolchains.isThisPlugin() fConfig=" + this.fConfig);
        }
        return (sToolchainId = (toolchain = this.fConfig.getToolChain()).getBaseId()).startsWith("ilg.gnumcueclipse.managedbuild.cross.riscv.toolchain.");
    }

    private boolean isManaged() {
        this.fConfig = this.getCfg();
        IManagedProject managedProject = this.fConfig.getManagedProject();
        IProjectType projectType = managedProject.getProjectType();
        return projectType != null && projectType.getId().startsWith(TYPE_PREFIX);
    }

    public void handleTabEvent(int kind, Object data) {
        super.handleTabEvent(kind, data);
        switch (kind) {
            case 4: {
                Page_BuildSettings pageConcrete = (Page_BuildSettings)((ICPropertyProvider2)this.page);
                pageConcrete.handleMessage(101, null);
                break;
            }
        }
    }
}

