/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu.ui;

import java.io.File;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.internal.debug.gdbjtag.qemu.ui.Activator;
import org.eclipse.embedcdt.internal.debug.gdbjtag.qemu.ui.Messages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class TabStartup
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Startup";
    private static final String TAB_ID = "org.eclipse.embedcdt.debug.gdbjtag.qemu.ui.ui.startuptab";
    private Text fInitCommands;
    private Button fDoFirstReset;
    private Button fDoSecondReset;
    private Label fSecondResetWarning;
    private Button fLoadExecutable;
    private Text fImageFileName;
    private Button fImageFileBrowseWs;
    private Button fImageFileBrowse;
    private Text fImageOffset;
    private Button fLoadSymbols;
    private Text fSymbolsFileName;
    private Button fSymbolsFileBrowseWs;
    private Button fSymbolsFileBrowse;
    private Text fSymbolsOffset;
    private Button fSetPcRegister;
    private Text fPcRegister;
    private Button fSetStopAt;
    private Text fStopAt;
    private Text fRunCommands;
    private Button fDoContinue;
    private Button fDoDebugInRam;
    private Button fUseProjectBinaryForImage;
    private Button fUseFileForImage;
    private Button fUseProjectBinaryForSymbols;
    private Button fUseFileForSymbols;
    private Label fImageOffsetLabel;
    private Label fSymbolsOffsetLabel;
    private Label fProjBinaryLabel1;
    private Label fProjBinaryLabel2;
    private String fSavedProgName;
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getStartupTabImage();
    }

    public void createControl(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.createControl() ");
        }
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createInitGroup(comp);
        this.createLoadGroup(comp);
        this.createRunOptionGroup(comp);
        this.createRunGroup(comp);
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.getString("DebuggerTab.restoreDefaults_Link"));
        restoreDefaults.setToolTipText(Messages.getString("DebuggerTab.restoreDefaults_ToolTipText"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabStartup.this.initializeFromDefaults();
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void browseWsButtonSelected(String title, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(Messages.getString("StartupTab.FileBrowseWs_Message"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
            text.setText(fileLoc);
        }
    }

    public void createInitGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.initGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        this.fDoFirstReset = new Button(local, 32);
        this.fDoFirstReset.setText(Messages.getString("StartupTab.doFirstReset_Text"));
        this.fDoFirstReset.setToolTipText(Messages.getString("StartupTab.doFirstReset_ToolTipText"));
        this.fInitCommands = new Text(comp, 2626);
        gd = new GridData(1808);
        gd.heightHint = 60;
        this.fInitCommands.setLayoutData((Object)gd);
        this.fDoFirstReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.doFirstResetChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        };
        this.fInitCommands.addModifyListener(scheduleUpdateJobModifyListener);
    }

    private void doFirstResetChanged() {
    }

    private void createLoadGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("StartupTab.loadGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fLoadSymbols = new Button(comp, 32);
        this.fLoadSymbols.setText(Messages.getString("StartupTab.loadSymbols_Text"));
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 4;
        layout3.marginHeight = 0;
        local.setLayout((Layout)layout3);
        local.setLayoutData((Object)new GridData(768));
        this.fUseProjectBinaryForSymbols = new Button(local, 16);
        this.fUseProjectBinaryForSymbols.setText(Messages.getString("StartupTab.useProjectBinary_Label"));
        this.fUseProjectBinaryForSymbols.setToolTipText(Messages.getString("StartupTab.useProjectBinary_ToolTip"));
        this.fProjBinaryLabel2 = new Label(local, 0);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        this.fProjBinaryLabel2.setLayoutData((Object)gd3);
        this.fUseFileForSymbols = new Button(local, 16);
        this.fUseFileForSymbols.setText(Messages.getString("StartupTab.useFile_Label"));
        this.fSymbolsFileName = new Text(local, 2048);
        gd3 = new GridData(768);
        this.fSymbolsFileName.setLayoutData((Object)gd3);
        this.fSymbolsFileBrowseWs = this.createPushButton(local, Messages.getString("StartupTab.FileBrowseWs_Label"), null);
        this.fSymbolsFileBrowse = this.createPushButton(local, Messages.getString("StartupTab.FileBrowse_Label"), null);
        this.fSymbolsOffsetLabel = new Label(local, 0);
        this.fSymbolsOffsetLabel.setText(Messages.getString("StartupTab.symbolsOffsetLabel_Text"));
        this.fSymbolsOffset = new Text(local, 2048);
        gd3 = new GridData();
        gd3.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        gd3.widthHint = 100;
        this.fSymbolsOffset.setLayoutData((Object)gd3);
        this.fLoadExecutable = new Button(comp, 32);
        this.fLoadExecutable.setText(Messages.getString("StartupTab.loadImage_Text"));
        local = new Composite(comp, 0);
        layout3 = new GridLayout();
        layout3.numColumns = 4;
        layout3.marginHeight = 0;
        local.setLayout((Layout)layout3);
        local.setLayoutData((Object)new GridData(768));
        this.fUseProjectBinaryForImage = new Button(local, 16);
        this.fUseProjectBinaryForImage.setText(Messages.getString("StartupTab.useProjectBinary_Label"));
        this.fUseProjectBinaryForImage.setToolTipText(Messages.getString("StartupTab.useProjectBinary_ToolTipText"));
        this.fProjBinaryLabel1 = new Label(local, 0);
        gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        this.fProjBinaryLabel1.setLayoutData((Object)gd3);
        this.fUseFileForImage = new Button(local, 16);
        this.fUseFileForImage.setText(Messages.getString("StartupTab.useFile_Label"));
        this.fImageFileName = new Text(local, 2048);
        gd3 = new GridData(768);
        this.fImageFileName.setLayoutData((Object)gd3);
        this.fImageFileBrowseWs = this.createPushButton(local, Messages.getString("StartupTab.FileBrowseWs_Label"), null);
        this.fImageFileBrowse = this.createPushButton(local, Messages.getString("StartupTab.FileBrowse_Label"), null);
        this.fImageOffsetLabel = new Label(local, 0);
        this.fImageOffsetLabel.setText(Messages.getString("StartupTab.imageOffsetLabel_Text"));
        this.fImageOffset = new Text(local, 2048);
        gd3 = new GridData();
        gd3.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        gd3.widthHint = ((GridData)this.fSymbolsOffset.getLayoutData()).widthHint;
        this.fImageOffset.setLayoutData((Object)gd3);
        this.fLoadExecutable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.loadExecutableChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        SelectionListener radioButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.updateUseFileEnablement();
                TabStartup.this.scheduleUpdateJob();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fUseProjectBinaryForImage.addSelectionListener(radioButtonListener);
        this.fUseFileForImage.addSelectionListener(radioButtonListener);
        this.fUseProjectBinaryForSymbols.addSelectionListener(radioButtonListener);
        this.fUseFileForSymbols.addSelectionListener(radioButtonListener);
        this.fImageFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fImageFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseWsButtonSelected(Messages.getString("StartupTab.imageFileBrowseWs_Title"), TabStartup.this.fImageFileName);
            }
        });
        this.fImageFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseButtonSelected(Messages.getString("StartupTab.imageFileBrowse_Title"), TabStartup.this.fImageFileName);
            }
        });
        this.fImageOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fImageOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fLoadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.loadSymbolsChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSymbolsFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSymbolsFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseWsButtonSelected(Messages.getString("StartupTab.symbolsFileBrowseWs_Title"), TabStartup.this.fSymbolsFileName);
            }
        });
        this.fSymbolsFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseButtonSelected(Messages.getString("StartupTab.symbolsFileBrowse_Title"), TabStartup.this.fSymbolsFileName);
            }
        });
        this.fSymbolsOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fSymbolsOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    private void updateUseFileEnablement() {
        boolean enabled = this.fLoadExecutable.getSelection() && this.fUseFileForImage.getSelection();
        this.fImageFileName.setEnabled(enabled);
        this.fImageFileBrowseWs.setEnabled(enabled);
        this.fImageFileBrowse.setEnabled(enabled);
        enabled = this.fLoadSymbols.getSelection() && this.fUseFileForSymbols.getSelection();
        this.fSymbolsFileName.setEnabled(enabled);
        this.fSymbolsFileBrowseWs.setEnabled(enabled);
        this.fSymbolsFileBrowse.setEnabled(enabled);
    }

    public void createRunOptionGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.runOptionGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fDoDebugInRam = new Button(comp, 32);
        this.fDoDebugInRam.setText(Messages.getString("StartupTab.doDebugInRam_Text"));
        this.fDoDebugInRam.setToolTipText(Messages.getString("StartupTab.doDebugInRam_ToolTipText"));
        this.fDoDebugInRam.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    private void doSecondResetChanged() {
        boolean enabled = this.fDoSecondReset.getSelection();
        this.fSecondResetWarning.setEnabled(enabled);
    }

    private void loadExecutableChanged() {
        boolean enabled = this.fLoadExecutable.getSelection();
        this.fUseProjectBinaryForImage.setEnabled(enabled);
        this.fUseFileForImage.setEnabled(enabled);
        this.fImageOffset.setEnabled(enabled);
        this.fImageOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void loadSymbolsChanged() {
        boolean enabled = this.fLoadSymbols.getSelection();
        this.fUseProjectBinaryForSymbols.setEnabled(enabled);
        this.fUseFileForSymbols.setEnabled(enabled);
        this.fSymbolsOffset.setEnabled(enabled);
        this.fSymbolsOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void pcRegisterChanged() {
        this.fPcRegister.setEnabled(this.fSetPcRegister.getSelection());
    }

    private void stopAtChanged() {
        this.fStopAt.setEnabled(this.fSetStopAt.getSelection());
    }

    public void createRunGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.runGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 4;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fDoSecondReset = new Button(comp, 32);
        this.fDoSecondReset.setText(Messages.getString("StartupTab.doSecondReset_Text"));
        this.fDoSecondReset.setToolTipText(Messages.getString("StartupTab.doSecondReset_ToolTipText"));
        this.fSecondResetWarning = new Label(comp, 0);
        this.fSecondResetWarning.setText(Messages.getString("StartupTab.secondResetWarning_Text"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fSecondResetWarning.setLayoutData((Object)gd);
        this.fRunCommands = new Text(comp, 2626);
        this.fRunCommands.setToolTipText(Messages.getString("StartupTab.runCommands_ToolTipText"));
        gd = new GridData(1808);
        gd.heightHint = 60;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fRunCommands.setLayoutData((Object)gd);
        this.fSetPcRegister = new Button(comp, 32);
        this.fSetPcRegister.setText(Messages.getString("StartupTab.setPcRegister_Text"));
        this.fSetPcRegister.setToolTipText(Messages.getString("StartupTab.setPcRegister_ToolTipText"));
        this.fPcRegister = new Text(comp, 2048);
        this.fPcRegister.setToolTipText(Messages.getString("StartupTab.pcRegister_ToolTipText"));
        gd = new GridData();
        gd.widthHint = 100;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fPcRegister.setLayoutData((Object)gd);
        this.fSetStopAt = new Button(comp, 32);
        this.fSetStopAt.setText(Messages.getString("StartupTab.setStopAt_Text"));
        this.fSetStopAt.setToolTipText(Messages.getString("StartupTab.setStopAt_ToolTipText"));
        this.fStopAt = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fStopAt.setLayoutData((Object)gd);
        this.fDoContinue = new Button(comp, 32);
        this.fDoContinue.setText(Messages.getString("StartupTab.doContinue_Text"));
        this.fDoContinue.setToolTipText(Messages.getString("StartupTab.doContinue_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoContinue.setLayoutData((Object)gd);
        this.fDoSecondReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.doSecondResetChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSetPcRegister.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.pcRegisterChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fPcRegister.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fPcRegister.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSetStopAt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.stopAtChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fStopAt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        };
        this.fRunCommands.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoContinue.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    public void doConnectToRunningChanged(boolean flag) {
        this.fDoFirstReset.setEnabled(!flag);
        this.fDoSecondReset.setEnabled(!flag);
        this.fSecondResetWarning.setEnabled(!flag);
        this.fLoadExecutable.setEnabled(!flag);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Path filePath;
        String path;
        if (!super.isValid(launchConfig)) {
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fLoadExecutable.getSelection()) {
            if (!this.fUseProjectBinaryForImage.getSelection()) {
                if (this.fImageFileName.getText().trim().isEmpty()) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_not_specified"));
                    return false;
                }
                try {
                    path = this.fImageFileName.getText().trim();
                    path = DebugUtils.resolveAll((String)path, (Map)launchConfig.getAttributes());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.fLoadSymbols.getSelection()) {
            if (!this.fUseProjectBinaryForSymbols.getSelection()) {
                if (this.fSymbolsFileName.getText().trim().isEmpty()) {
                    this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_not_specified"));
                    return false;
                }
                try {
                    path = this.fSymbolsFileName.getText().trim();
                    path = DebugUtils.resolveAll((String)path, (Map)launchConfig.getAttributes());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.fSetPcRegister.getSelection()) {
            if (this.fPcRegister.getText().trim().isEmpty()) {
                this.setErrorMessage(Messages.getString("StartupTab.pcRegister_not_specified"));
                return false;
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.fSetStopAt.getSelection()) {
            if (this.fStopAt.getText().trim().isEmpty()) {
                this.setErrorMessage(Messages.getString("StartupTab.stopAt_not_specified"));
            }
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    public String getId() {
        return TAB_ID;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.initializeFrom() " + configuration.getName() + ", dirty=" + this.isDirty());
        }
        try {
            boolean booleanDefault = this.fPersistentPreferences.getQemuDoInitialReset();
            this.fDoFirstReset.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doFirstReset", booleanDefault));
            String stringDefault = this.fPersistentPreferences.getQemuInitOther();
            this.fInitCommands.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.otherInitCommands", stringDefault));
            this.fLoadSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true));
            this.fUseProjectBinaryForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true));
            this.fUseFileForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false));
            this.fSymbolsFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", ""));
            this.fSymbolsOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", ""));
            this.fLoadExecutable.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true));
            this.fUseProjectBinaryForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true));
            this.fUseFileForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false));
            this.fImageFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", ""));
            this.fImageOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""));
            String programName = CDebugUtils.getProgramName((ILaunchConfiguration)configuration);
            if (programName != null) {
                int lastSlash = programName.indexOf(92);
                if (lastSlash >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                if ((lastSlash = programName.indexOf(47)) >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                this.fProjBinaryLabel1.setText(programName);
                this.fProjBinaryLabel2.setText(programName);
            }
            this.fSavedProgName = programName;
            booleanDefault = this.fPersistentPreferences.getQemuDebugInRam();
            this.fDoDebugInRam.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doDebugInRam", booleanDefault));
            booleanDefault = this.fPersistentPreferences.getQemuDoPreRunReset();
            this.fDoSecondReset.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doSecondReset", booleanDefault));
            stringDefault = this.fPersistentPreferences.getQemuPreRunOther();
            this.fRunCommands.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.otherRunCommands", stringDefault));
            this.fSetPcRegister.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false));
            this.fPcRegister.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", ""));
            this.fSetStopAt.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", true));
            this.fStopAt.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "main"));
            this.fDoContinue.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doContinue", true));
            this.doFirstResetChanged();
            this.doSecondResetChanged();
            this.loadExecutableChanged();
            this.loadSymbolsChanged();
            this.pcRegisterChanged();
            this.stopAtChanged();
            this.updateUseFileEnablement();
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.initializeFrom() completed " + configuration.getName() + ", dirty=" + this.isDirty());
        }
    }

    public void initializeFromDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.initializeFromDefaults()");
        }
        boolean booleanDefault = this.fDefaultPreferences.getQemuDoInitialReset();
        this.fDoFirstReset.setSelection(booleanDefault);
        String stringDefault = this.fDefaultPreferences.getQemuInitOther();
        this.fInitCommands.setText(stringDefault);
        this.fLoadSymbols.setSelection(true);
        this.fUseProjectBinaryForSymbols.setSelection(true);
        this.fUseFileForSymbols.setSelection(false);
        this.fSymbolsFileName.setText("");
        this.fSymbolsOffset.setText("");
        this.fLoadExecutable.setSelection(true);
        this.fUseProjectBinaryForImage.setSelection(true);
        this.fUseFileForImage.setSelection(false);
        this.fImageFileName.setText("");
        this.fImageOffset.setText("");
        String programName = this.fSavedProgName;
        if (programName != null) {
            this.fProjBinaryLabel1.setText(programName);
            this.fProjBinaryLabel2.setText(programName);
        }
        booleanDefault = this.fDefaultPreferences.getQemuDebugInRam();
        this.fDoDebugInRam.setSelection(booleanDefault);
        booleanDefault = this.fDefaultPreferences.getQemuDoPreRunReset();
        this.fDoSecondReset.setSelection(booleanDefault);
        stringDefault = this.fDefaultPreferences.getQemuPreRunOther();
        this.fRunCommands.setText(stringDefault);
        this.fSetPcRegister.setSelection(false);
        this.fPcRegister.setText("");
        this.fSetStopAt.setSelection(true);
        this.fStopAt.setText("main");
        this.fDoContinue.setSelection(true);
        this.doFirstResetChanged();
        this.doSecondResetChanged();
        this.loadExecutableChanged();
        this.loadSymbolsChanged();
        this.pcRegisterChanged();
        this.stopAtChanged();
        this.updateUseFileEnablement();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.activated() " + workingCopy.getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.deactivated() " + workingCopy.getName());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.performApply() " + configuration.getName() + ", dirty=" + this.isDirty());
        }
        boolean booleanValue = this.fDoFirstReset.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doFirstReset", booleanValue);
        this.fPersistentPreferences.putQemuDoInitialReset(booleanValue);
        String stringValue = this.fInitCommands.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.otherInitCommands", stringValue);
        this.fPersistentPreferences.putQemuInitOther(stringValue);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", this.fLoadSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", this.fUseProjectBinaryForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", this.fUseFileForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", this.fSymbolsFileName.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", this.fSymbolsOffset.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", this.fLoadExecutable.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", this.fUseProjectBinaryForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", this.fUseFileForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", this.fImageFileName.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", this.fImageOffset.getText());
        booleanValue = this.fDoDebugInRam.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doDebugInRam", booleanValue);
        this.fPersistentPreferences.putQemuDebugInRam(booleanValue);
        booleanValue = this.fDoSecondReset.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doSecondReset", booleanValue);
        this.fPersistentPreferences.putQemuDoPreRunReset(booleanValue);
        stringValue = this.fRunCommands.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.otherRunCommands", stringValue);
        this.fPersistentPreferences.putQemuPreRunOther(stringValue);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", this.fSetPcRegister.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", this.fPcRegister.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", this.fSetStopAt.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", this.fStopAt.getText());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doContinue", this.fDoContinue.getSelection());
        this.fPersistentPreferences.flush();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.performApply() completed " + configuration.getName() + ", dirty=" + this.isDirty());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.TabStartup.setDefaults() " + configuration.getName());
        }
        boolean defaultBoolean = this.fPersistentPreferences.getQemuDoInitialReset();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doFirstReset", defaultBoolean);
        defaultBoolean = this.fPersistentPreferences.getQemuEnableSemihosting();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.enableSemihosting", defaultBoolean);
        String defaultString = this.fPersistentPreferences.getQemuInitOther();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.otherInitCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
        defaultBoolean = this.fPersistentPreferences.getQemuDebugInRam();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doDebugInRam", defaultBoolean);
        defaultBoolean = this.fPersistentPreferences.getQemuDoPreRunReset();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doSecondReset", defaultBoolean);
        defaultString = this.fPersistentPreferences.getQemuPreRunOther();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.otherRunCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "main");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doContinue", true);
    }
}

