/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public class MidxPackFilter {
    private MidxPackFilter() {
    }

    public static List<DfsPackDescription> skipMidxs(List<DfsPackDescription> packs) {
        return packs.stream().filter(desc -> !desc.hasFileExt(PackExt.MULTI_PACK_INDEX)).collect(Collectors.toList());
    }

    public static List<DfsPackDescription> useMidx(List<DfsPackDescription> packs) {
        List<DfsPackDescription> midxs = packs.stream().filter(desc -> desc.hasFileExt(PackExt.MULTI_PACK_INDEX)).toList();
        if (midxs.isEmpty()) {
            return packs;
        }
        HashSet<DfsPackDescription> inputPacks = new HashSet<DfsPackDescription>(packs);
        HashSet<DfsPackDescription> allCoveredPacks = new HashSet<DfsPackDescription>();
        for (DfsPackDescription midx : midxs) {
            HashSet<DfsPackDescription> coveredPacks = new HashSet<DfsPackDescription>();
            MidxPackFilter.findCoveredPacks(midx, coveredPacks);
            if (!inputPacks.containsAll(coveredPacks)) {
                return MidxPackFilter.skipMidxs(packs);
            }
            allCoveredPacks.addAll(coveredPacks);
        }
        return packs.stream().filter(d -> !allCoveredPacks.contains(d)).collect(Collectors.toList());
    }

    private static void findCoveredPacks(DfsPackDescription midx, Set<DfsPackDescription> covered) {
        if (!midx.getCoveredPacks().isEmpty()) {
            covered.addAll(midx.getCoveredPacks());
        }
        if (midx.getMultiPackIndexBase() != null) {
            MidxPackFilter.findCoveredPacks(midx.getMultiPackIndexBase(), covered);
            covered.add(midx.getMultiPackIndexBase());
        }
    }
}

