/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.domain.file;

import java.util.Arrays;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.domain.Activator;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.LoadableDomainHelper;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.model.domain.LoadableDomain;
import org.eclipse.egf.model.domain.WorkspaceDomain;
import org.eclipse.osgi.util.NLS;

public class WorkspaceDomainHelper
extends LoadableDomainHelper {
    protected boolean doLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof WorkspaceDomain) {
            Path path2;
            WorkspaceDomain myDomain;
            block7: {
                myDomain = (WorkspaceDomain)domain;
                String path = myDomain.getPath();
                myDomain.setLoaded(true);
                if (path == null || "".equals(path)) {
                    Activator.getDefault().logWarning(Messages.bind((String)Messages.Load_WorkspaceDomain_error1, (Object)domain.getName()));
                    return true;
                }
                if (!myDomain.getContent().isEmpty()) {
                    throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
                }
                if (".".equals(path)) {
                    myDomain.getContent().addAll(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
                    return true;
                }
                path2 = new Path(path);
                int segmentCount = path2.segmentCount();
                try {
                    if (segmentCount != 1) break block7;
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path);
                    myDomain.getContent().addAll(Arrays.asList(project.members()));
                    return true;
                }
                catch (CoreException e) {
                    throw new DomainException(NLS.bind((String)Messages.Load_WorkspaceDomain_error2, (Object)path2), e);
                }
            }
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path2);
            myDomain.getContent().addAll(Arrays.asList(folder.members()));
            return true;
        }
        return false;
    }

    protected boolean doUnLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof WorkspaceDomain) {
            WorkspaceDomain myDomain = (WorkspaceDomain)domain;
            myDomain.getContent().clear();
            myDomain.setLoaded(false);
            return true;
        }
        return false;
    }
}

